/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.AuthManager;
import com.squareup.square.Configuration;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.V1TransactionsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.models.V1CreateRefundRequest;
import com.squareup.square.models.V1Order;
import com.squareup.square.models.V1Payment;
import com.squareup.square.models.V1Refund;
import com.squareup.square.models.V1Settlement;
import com.squareup.square.models.V1UpdateOrderRequest;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class DefaultV1TransactionsApi
extends BaseApi
implements V1TransactionsApi {
    public DefaultV1TransactionsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public DefaultV1TransactionsApi(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    @Override
    @Deprecated
    public List<V1Order> listOrders(String locationId, String order, Integer limit, String batchToken) throws ApiException, IOException {
        HttpRequest request = this.buildListOrdersRequest(locationId, order, limit, batchToken);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListOrdersResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<List<V1Order>> listOrdersAsync(String locationId, String order, Integer limit, String batchToken) {
        return this.makeHttpCallAsync(() -> this.buildListOrdersRequest(locationId, order, limit, batchToken), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListOrdersResponse(context));
    }

    private HttpRequest buildListOrdersRequest(String locationId, String order, Integer limit, String batchToken) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v1/{location_id}/orders");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("order", order);
        queryParameters.put("limit", limit);
        queryParameters.put("batch_token", batchToken);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private List<V1Order> handleListOrdersResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List<V1Order> result = ApiHelper.deserializeArray(responseBody, V1Order[].class);
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, result.get(i).toBuilder().httpContext(context).build());
        }
        return result;
    }

    @Override
    @Deprecated
    public V1Order retrieveOrder(String locationId, String orderId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveOrderRequest(locationId, orderId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveOrderResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<V1Order> retrieveOrderAsync(String locationId, String orderId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveOrderRequest(locationId, orderId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveOrderResponse(context));
    }

    private HttpRequest buildRetrieveOrderRequest(String locationId, String orderId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v1/{location_id}/orders/{order_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        templateParameters.put("order_id", new AbstractMap.SimpleEntry<String, Boolean>(orderId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private V1Order handleRetrieveOrderResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        V1Order result = ApiHelper.deserialize(responseBody, V1Order.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public V1Order updateOrder(String locationId, String orderId, V1UpdateOrderRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateOrderRequest(locationId, orderId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateOrderResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<V1Order> updateOrderAsync(String locationId, String orderId, V1UpdateOrderRequest body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateOrderRequest(locationId, orderId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateOrderResponse(context));
    }

    private HttpRequest buildUpdateOrderRequest(String locationId, String orderId, V1UpdateOrderRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v1/{location_id}/orders/{order_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        templateParameters.put("order_id", new AbstractMap.SimpleEntry<String, Boolean>(orderId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private V1Order handleUpdateOrderResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        V1Order result = ApiHelper.deserialize(responseBody, V1Order.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public List<V1Payment> listPayments(String locationId, String order, String beginTime, String endTime, Integer limit, String batchToken, Boolean includePartial) throws ApiException, IOException {
        HttpRequest request = this.buildListPaymentsRequest(locationId, order, beginTime, endTime, limit, batchToken, includePartial);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListPaymentsResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<List<V1Payment>> listPaymentsAsync(String locationId, String order, String beginTime, String endTime, Integer limit, String batchToken, Boolean includePartial) {
        return this.makeHttpCallAsync(() -> this.buildListPaymentsRequest(locationId, order, beginTime, endTime, limit, batchToken, includePartial), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListPaymentsResponse(context));
    }

    private HttpRequest buildListPaymentsRequest(String locationId, String order, String beginTime, String endTime, Integer limit, String batchToken, Boolean includePartial) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v1/{location_id}/payments");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("order", order);
        queryParameters.put("begin_time", beginTime);
        queryParameters.put("end_time", endTime);
        queryParameters.put("limit", limit);
        queryParameters.put("batch_token", batchToken);
        queryParameters.put("include_partial", includePartial != null ? includePartial : false);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private List<V1Payment> handleListPaymentsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List<V1Payment> result = ApiHelper.deserializeArray(responseBody, V1Payment[].class);
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, result.get(i).toBuilder().httpContext(context).build());
        }
        return result;
    }

    @Override
    @Deprecated
    public V1Payment retrievePayment(String locationId, String paymentId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrievePaymentRequest(locationId, paymentId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrievePaymentResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<V1Payment> retrievePaymentAsync(String locationId, String paymentId) {
        return this.makeHttpCallAsync(() -> this.buildRetrievePaymentRequest(locationId, paymentId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrievePaymentResponse(context));
    }

    private HttpRequest buildRetrievePaymentRequest(String locationId, String paymentId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v1/{location_id}/payments/{payment_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        templateParameters.put("payment_id", new AbstractMap.SimpleEntry<String, Boolean>(paymentId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private V1Payment handleRetrievePaymentResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        V1Payment result = ApiHelper.deserialize(responseBody, V1Payment.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public List<V1Refund> listRefunds(String locationId, String order, String beginTime, String endTime, Integer limit, String batchToken) throws ApiException, IOException {
        HttpRequest request = this.buildListRefundsRequest(locationId, order, beginTime, endTime, limit, batchToken);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListRefundsResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<List<V1Refund>> listRefundsAsync(String locationId, String order, String beginTime, String endTime, Integer limit, String batchToken) {
        return this.makeHttpCallAsync(() -> this.buildListRefundsRequest(locationId, order, beginTime, endTime, limit, batchToken), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListRefundsResponse(context));
    }

    private HttpRequest buildListRefundsRequest(String locationId, String order, String beginTime, String endTime, Integer limit, String batchToken) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v1/{location_id}/refunds");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("order", order);
        queryParameters.put("begin_time", beginTime);
        queryParameters.put("end_time", endTime);
        queryParameters.put("limit", limit);
        queryParameters.put("batch_token", batchToken);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private List<V1Refund> handleListRefundsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List<V1Refund> result = ApiHelper.deserializeArray(responseBody, V1Refund[].class);
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, result.get(i).toBuilder().httpContext(context).build());
        }
        return result;
    }

    @Override
    @Deprecated
    public V1Refund createRefund(String locationId, V1CreateRefundRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateRefundRequest(locationId, body);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateRefundResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<V1Refund> createRefundAsync(String locationId, V1CreateRefundRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateRefundRequest(locationId, body), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateRefundResponse(context));
    }

    private HttpRequest buildCreateRefundRequest(String locationId, V1CreateRefundRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v1/{location_id}/refunds");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", "application/json");
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private V1Refund handleCreateRefundResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        V1Refund result = ApiHelper.deserialize(responseBody, V1Refund.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }

    @Override
    @Deprecated
    public List<V1Settlement> listSettlements(String locationId, String order, String beginTime, String endTime, Integer limit, String status, String batchToken) throws ApiException, IOException {
        HttpRequest request = this.buildListSettlementsRequest(locationId, order, beginTime, endTime, limit, status, batchToken);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListSettlementsResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<List<V1Settlement>> listSettlementsAsync(String locationId, String order, String beginTime, String endTime, Integer limit, String status, String batchToken) {
        return this.makeHttpCallAsync(() -> this.buildListSettlementsRequest(locationId, order, beginTime, endTime, limit, status, batchToken), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListSettlementsResponse(context));
    }

    private HttpRequest buildListSettlementsRequest(String locationId, String order, String beginTime, String endTime, Integer limit, String status, String batchToken) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v1/{location_id}/settlements");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("order", order);
        queryParameters.put("begin_time", beginTime);
        queryParameters.put("end_time", endTime);
        queryParameters.put("limit", limit);
        queryParameters.put("status", status);
        queryParameters.put("batch_token", batchToken);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private List<V1Settlement> handleListSettlementsResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List<V1Settlement> result = ApiHelper.deserializeArray(responseBody, V1Settlement[].class);
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, result.get(i).toBuilder().httpContext(context).build());
        }
        return result;
    }

    @Override
    @Deprecated
    public V1Settlement retrieveSettlement(String locationId, String settlementId) throws ApiException, IOException {
        HttpRequest request = this.buildRetrieveSettlementRequest(locationId, settlementId);
        ((AuthManager)this.authManagers.get("global")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRetrieveSettlementResponse(context);
    }

    @Override
    @Deprecated
    public CompletableFuture<V1Settlement> retrieveSettlementAsync(String locationId, String settlementId) {
        return this.makeHttpCallAsync(() -> this.buildRetrieveSettlementRequest(locationId, settlementId), req -> ((AuthManager)this.authManagers.get("global")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRetrieveSettlementResponse(context));
    }

    private HttpRequest buildRetrieveSettlementRequest(String locationId, String settlementId) {
        String baseUri = this.config.getBaseUri();
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/v1/{location_id}/settlements/{settlement_id}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("location_id", new AbstractMap.SimpleEntry<String, Boolean>(locationId, true));
        templateParameters.put("settlement_id", new AbstractMap.SimpleEntry<String, Boolean>(settlementId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Square-Version", this.config.getSquareVersion());
        headers.add("user-agent", this.internalUserAgent);
        headers.add("accept", "application/json");
        headers.addAll(this.config.getAdditionalHeaders());
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private V1Settlement handleRetrieveSettlementResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        V1Settlement result = ApiHelper.deserialize(responseBody, V1Settlement.class);
        result = result.toBuilder().httpContext(context).build();
        return result;
    }
}

