/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.exceptions;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.square.ApiHelper;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Payment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ApiException
extends Exception {
    private static final long serialVersionUID = 6424174253911720338L;
    private HttpContext httpContext;
    private Object data;
    private List<Error> errors;

    public ApiException(String reason) {
        super(reason);
    }

    public ApiException(String reason, HttpContext context) {
        super(reason);
        this.httpContext = context;
        if (context == null || context.getResponse() == null || context.getResponse().getRawBody() == null) {
            return;
        }
        try {
            JsonNode jsonNode = ApiHelper.mapper.readTree(context.getResponse().getRawBody());
            if (jsonNode.hasNonNull("payment")) {
                this.data = ApiHelper.mapper.convertValue((Object)jsonNode.get("payment"), Payment.class);
            }
            if (jsonNode.hasNonNull("errors")) {
                this.errors = Arrays.asList((Object[])ApiHelper.mapper.convertValue((Object)jsonNode.get("errors"), Error[].class));
            } else {
                this.errors = new ArrayList<Error>();
                Error.Builder v1ErrorBuilder = new Error.Builder("V1_ERROR", jsonNode.hasNonNull("type") ? jsonNode.get("type").asText() : null);
                if (jsonNode.hasNonNull("message")) {
                    v1ErrorBuilder.detail(jsonNode.get("message").asText());
                }
                this.errors.add(v1ErrorBuilder.build());
            }
            if (!this.getClass().equals(ApiException.class)) {
                ApiHelper.mapper.readerForUpdating((Object)this).readValue(jsonNode);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getResponseCode() {
        return this.httpContext != null ? this.httpContext.getResponse().getStatusCode() : -1;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public Object getData() {
        return this.data;
    }

    public List<Error> getErrors() {
        return this.errors;
    }
}

