/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.http.client;

import com.squareup.square.ApiHelper;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpClient;
import com.squareup.square.http.client.HttpRedirectInterceptor;
import com.squareup.square.http.client.ReadonlyHttpClientConfiguration;
import com.squareup.square.http.client.RetryInterceptor;
import com.squareup.square.http.request.HttpBodyRequest;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.http.request.HttpRequest;
import com.squareup.square.http.request.MultipartFileWrapper;
import com.squareup.square.http.request.MultipartWrapper;
import com.squareup.square.http.request.configuration.RetryConfiguration;
import com.squareup.square.http.response.HttpResponse;
import com.squareup.square.http.response.HttpStringResponse;
import com.squareup.square.utilities.FileWrapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkClient
implements HttpClient {
    private static final Object syncObject = new Object();
    private static volatile OkHttpClient defaultOkHttpClient;
    private OkHttpClient client;

    public OkClient(ReadonlyHttpClientConfiguration httpClientConfig) {
        OkHttpClient httpClientInstance = httpClientConfig.getHttpClientInstance();
        if (httpClientInstance != null) {
            if (httpClientConfig.shouldOverrideHttpClientConfigurations()) {
                this.applyHttpClientConfigurations(httpClientInstance, httpClientConfig);
            } else {
                this.client = httpClientInstance;
            }
        } else {
            this.applyHttpClientConfigurations(this.getDefaultOkHttpClient(), httpClientConfig);
        }
    }

    private void applyHttpClientConfigurations(OkHttpClient client, ReadonlyHttpClientConfiguration httpClientConfig) {
        OkHttpClient.Builder clientBuilder = client.newBuilder();
        clientBuilder.readTimeout(httpClientConfig.getTimeout(), TimeUnit.SECONDS).writeTimeout(httpClientConfig.getTimeout(), TimeUnit.SECONDS).connectTimeout(httpClientConfig.getTimeout(), TimeUnit.SECONDS);
        clientBuilder.addInterceptor((Interceptor)new HttpRedirectInterceptor(true));
        if (httpClientConfig.getNumberOfRetries() > 0) {
            clientBuilder.callTimeout(httpClientConfig.getMaximumRetryWaitTime(), TimeUnit.SECONDS).addInterceptor((Interceptor)new RetryInterceptor(httpClientConfig));
        } else {
            clientBuilder.callTimeout(httpClientConfig.getTimeout(), TimeUnit.SECONDS);
        }
        this.client = clientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OkHttpClient getDefaultOkHttpClient() {
        if (defaultOkHttpClient == null) {
            Object object = syncObject;
            synchronized (object) {
                if (defaultOkHttpClient == null) {
                    defaultOkHttpClient = new OkHttpClient.Builder().retryOnConnectionFailure(false).callTimeout(60L, TimeUnit.SECONDS).build();
                }
            }
        }
        return defaultOkHttpClient;
    }

    public static void shutdown() {
        if (defaultOkHttpClient != null) {
            defaultOkHttpClient.dispatcher().executorService().shutdown();
            defaultOkHttpClient.connectionPool().evictAll();
        }
    }

    @Override
    public CompletableFuture<HttpResponse> executeAsync(final HttpRequest httpRequest, final boolean hasBinaryResponse, RetryConfiguration retryConfiguration) {
        Request okHttpRequest = this.convertRequest(httpRequest);
        RetryInterceptor retryInterceptor = this.getRetryInterceptor();
        if (retryInterceptor != null) {
            retryInterceptor.addRequestEntry(okHttpRequest, retryConfiguration);
        }
        final CompletableFuture<HttpResponse> callBack = new CompletableFuture<HttpResponse>();
        this.client.newCall(okHttpRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OkClient.this.publishResponse(null, httpRequest, callBack, e, hasBinaryResponse);
            }

            public void onResponse(Call call, Response okHttpResponse) {
                OkClient.this.publishResponse(okHttpResponse, httpRequest, callBack, null, hasBinaryResponse);
            }
        });
        return callBack;
    }

    @Override
    public CompletableFuture<HttpResponse> executeAsync(HttpRequest httpRequest, boolean hasBinaryResponse) {
        return this.executeAsync(httpRequest, hasBinaryResponse, new RetryConfiguration.Builder().build());
    }

    @Override
    public HttpResponse execute(HttpRequest httpRequest, boolean hasBinaryResponse, RetryConfiguration retryConfiguration) throws IOException {
        Request okHttpRequest = this.convertRequest(httpRequest);
        RetryInterceptor retryInterceptor = this.getRetryInterceptor();
        if (retryInterceptor != null) {
            retryInterceptor.addRequestEntry(okHttpRequest, retryConfiguration);
        }
        Response okHttpResponse = null;
        okHttpResponse = this.client.newCall(okHttpRequest).execute();
        return OkClient.convertResponse(httpRequest, okHttpResponse, hasBinaryResponse);
    }

    @Override
    public HttpResponse execute(HttpRequest httpRequest, boolean hasBinaryResponse) throws IOException {
        return this.execute(httpRequest, hasBinaryResponse, new RetryConfiguration.Builder().build());
    }

    private RetryInterceptor getRetryInterceptor() {
        return this.client.interceptors().stream().filter(interceptor -> interceptor instanceof RetryInterceptor).findFirst().orElse(null);
    }

    private HttpResponse publishResponse(Response okHttpResponse, HttpRequest httpRequest, CompletableFuture<HttpResponse> completionBlock, Throwable error, boolean hasBinaryResponse) {
        HttpResponse httpResponse = null;
        try {
            httpResponse = OkClient.convertResponse(httpRequest, okHttpResponse, hasBinaryResponse);
            if (error == null && httpResponse != null) {
                completionBlock.complete(httpResponse);
            } else {
                completionBlock.completeExceptionally(error);
            }
        }
        catch (IOException e) {
            completionBlock.completeExceptionally(e);
        }
        return httpResponse;
    }

    protected static HttpResponse convertResponse(HttpRequest request, Response response, boolean hasBinaryResponse) throws IOException {
        HttpResponse httpResponse = null;
        if (response != null) {
            ResponseBody responseBody = response.body();
            Headers headers = new Headers(response.headers().toMultimap());
            if (hasBinaryResponse) {
                InputStream responseStream = responseBody.byteStream();
                httpResponse = new HttpResponse(response.code(), headers, responseStream);
            } else {
                String responseString = responseBody.string();
                ByteArrayInputStream responseStream = new ByteArrayInputStream(responseString.getBytes());
                httpResponse = new HttpStringResponse(response.code(), headers, responseStream, responseString);
                responseBody.close();
                response.close();
            }
        }
        return httpResponse;
    }

    private Request convertRequest(HttpRequest httpRequest) {
        RequestBody requestBody;
        if (httpRequest instanceof HttpBodyRequest) {
            String contentType;
            Object body = ((HttpBodyRequest)httpRequest).getBody();
            if (body instanceof FileWrapper) {
                FileWrapper file = (FileWrapper)body;
                if (file.getContentType() != null && !file.getContentType().isEmpty()) {
                    contentType = file.getContentType();
                    httpRequest.getHeaders().add("content-type", contentType);
                } else if (httpRequest.getHeaders().has("content-type")) {
                    contentType = httpRequest.getHeaders().value("content-type");
                } else {
                    contentType = "application/octet-stream";
                    httpRequest.getHeaders().add("content-type", contentType);
                }
                requestBody = RequestBody.create((File)file.getFile(), (MediaType)MediaType.parse((String)contentType));
            } else {
                if (!httpRequest.getHeaders().has("content-type")) {
                    httpRequest.getHeaders().add("content-type", "application/json; charset=UTF-8");
                }
                contentType = httpRequest.getHeaders().value("content-type");
                requestBody = RequestBody.create((byte[])((String)body).getBytes(), (MediaType)MediaType.parse((String)contentType));
            }
        } else {
            List<AbstractMap.SimpleEntry<String, Object>> parameters = httpRequest.getParameters();
            boolean multipartRequest = false;
            if (parameters != null && parameters.size() > 0) {
                for (AbstractMap.SimpleEntry simpleEntry : parameters) {
                    if (!(simpleEntry.getValue() instanceof MultipartFileWrapper) && !(simpleEntry.getValue() instanceof MultipartWrapper)) continue;
                    multipartRequest = true;
                    break;
                }
                if (multipartRequest) {
                    requestBody = OkClient.createMultipartRequestBody(httpRequest);
                } else {
                    FormBody.Builder formBuilder = new FormBody.Builder();
                    for (AbstractMap.SimpleEntry<String, Object> simpleEntry : parameters) {
                        formBuilder.add(simpleEntry.getKey(), simpleEntry.getValue() == null ? "" : simpleEntry.getValue().toString());
                    }
                    requestBody = formBuilder.build();
                }
            } else {
                requestBody = httpRequest.getHttpMethod().equals((Object)HttpMethod.GET) ? null : RequestBody.create((byte[])new byte[0], null);
            }
        }
        Headers.Builder requestHeaders = new Headers.Builder();
        if (httpRequest.getHeaders() != null) {
            requestHeaders = OkClient.createRequestHeaders(httpRequest.getHeaders());
        }
        StringBuilder urlBuilder = new StringBuilder(httpRequest.getQueryUrl());
        ApiHelper.appendUrlWithQueryParameters(urlBuilder, httpRequest.getQueryParameters());
        String url = ApiHelper.cleanUrl(urlBuilder);
        Request request = new Request.Builder().method(httpRequest.getHttpMethod().toString(), requestBody).headers(requestHeaders.build()).url(url).build();
        return request;
    }

    private static RequestBody createMultipartRequestBody(HttpRequest httpRequest) {
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (AbstractMap.SimpleEntry<String, Object> param : httpRequest.getParameters()) {
            if (param.getValue() instanceof MultipartFileWrapper) {
                MultipartFileWrapper wrapperObj = (MultipartFileWrapper)param.getValue();
                MediaType mediaType = wrapperObj.getFileWrapper().getContentType() != null && !wrapperObj.getFileWrapper().getContentType().isEmpty() ? MediaType.parse((String)wrapperObj.getFileWrapper().getContentType()) : MediaType.parse((String)wrapperObj.getHeaders().value("content-type"));
                RequestBody body = RequestBody.create((File)wrapperObj.getFileWrapper().getFile(), (MediaType)mediaType);
                Headers fileWrapperHeaders = new Headers(wrapperObj.getHeaders());
                fileWrapperHeaders.remove("content-type");
                Headers.Builder fileWrapperHeadersBuilder = OkClient.createRequestHeaders(fileWrapperHeaders);
                fileWrapperHeadersBuilder.add("Content-Disposition", "form-data; name=" + OkClient.appendQuotedStringAndEncodeEscapeCharacters(param.getKey()) + "; filename=" + OkClient.appendQuotedStringAndEncodeEscapeCharacters(wrapperObj.getFileWrapper().getFile().getName()));
                multipartBuilder.addPart(fileWrapperHeadersBuilder.build(), body);
                continue;
            }
            if (param.getValue() instanceof MultipartWrapper) {
                MultipartWrapper wrapperObject = (MultipartWrapper)param.getValue();
                RequestBody body = RequestBody.create((byte[])wrapperObject.getByteArray(), (MediaType)MediaType.parse((String)wrapperObject.getHeaders().value("content-type")));
                Headers wrapperHeaders = new Headers(wrapperObject.getHeaders());
                wrapperHeaders.remove("content-type");
                Headers.Builder wrapperHeadersBuilder = OkClient.createRequestHeaders(wrapperHeaders);
                wrapperHeadersBuilder.add("Content-Disposition", "form-data; name=" + OkClient.appendQuotedStringAndEncodeEscapeCharacters(param.getKey()));
                multipartBuilder.addPart(wrapperHeadersBuilder.build(), body);
                continue;
            }
            multipartBuilder.addFormDataPart(param.getKey(), param.getValue() == null ? "" : param.getValue().toString());
        }
        return multipartBuilder.build();
    }

    private static Headers.Builder createRequestHeaders(Headers headers) {
        Headers.Builder requestHeaders = new Headers.Builder();
        for (Map.Entry<String, List<String>> kv : headers.asMultimap().entrySet()) {
            for (String value : kv.getValue()) {
                requestHeaders.add(kv.getKey(), value);
            }
        }
        return requestHeaders;
    }

    private static String appendQuotedStringAndEncodeEscapeCharacters(String key) {
        String target = "\"";
        int len = key.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            switch (ch) {
                case '\n': {
                    target = target + "%0A";
                    continue block5;
                }
                case '\r': {
                    target = target + "%0D";
                    continue block5;
                }
                case '\"': {
                    target = target + "%22";
                    continue block5;
                }
                default: {
                    target = target + ch;
                }
            }
        }
        target = target + '\"';
        return target;
    }

    @Override
    public HttpRequest get(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.GET, queryUrlBuilder, headers, queryParams, parameters);
    }

    @Override
    public HttpRequest head(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.HEAD, queryUrlBuilder, headers, queryParams, parameters);
    }

    @Override
    public HttpRequest post(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.POST, queryUrlBuilder, headers, queryParams, parameters);
    }

    @Override
    public HttpBodyRequest postBody(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, Object body) {
        return new HttpBodyRequest(HttpMethod.POST, queryUrlBuilder, headers, queryParams, body);
    }

    @Override
    public HttpRequest put(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.PUT, queryUrlBuilder, headers, queryParams, parameters);
    }

    @Override
    public HttpBodyRequest putBody(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, Object body) {
        return new HttpBodyRequest(HttpMethod.PUT, queryUrlBuilder, headers, queryParams, body);
    }

    @Override
    public HttpRequest patch(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.PATCH, queryUrlBuilder, headers, queryParams, parameters);
    }

    @Override
    public HttpBodyRequest patchBody(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, Object body) {
        return new HttpBodyRequest(HttpMethod.PATCH, queryUrlBuilder, headers, queryParams, body);
    }

    @Override
    public HttpRequest delete(StringBuilder queryUrl, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.DELETE, queryUrl, headers, queryParams, parameters);
    }

    @Override
    public HttpBodyRequest deleteBody(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, Object body) {
        return new HttpBodyRequest(HttpMethod.DELETE, queryUrlBuilder, headers, queryParams, body);
    }
}

