/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.http.client;

import com.squareup.square.http.client.ReadonlyHttpClientConfiguration;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.http.request.configuration.RetryConfiguration;
import java.io.IOException;
import java.net.SocketException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryInterceptor
implements Interceptor {
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z").withZone(ZoneId.of("GMT"));
    private final ConcurrentMap<Request, RequestState> requestEntries;
    private final ReadonlyHttpClientConfiguration httpClientConfiguration;

    public RetryInterceptor(ReadonlyHttpClientConfiguration httpClientConfig) {
        this.httpClientConfiguration = httpClientConfig;
        this.requestEntries = new ConcurrentHashMap<Request, RequestState>();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestState requestState = this.getRequestState(request);
        boolean isWhitelistedRequestMethod = this.httpClientConfiguration.getHttpMethodsToRetry().contains((Object)HttpMethod.valueOf(request.method()));
        boolean isRetryAllowedForRequest = requestState.retryConfiguration.getRetryOption().isRetryAllowed(isWhitelistedRequestMethod);
        Response response = null;
        IOException timeoutException = null;
        boolean shouldRetry = false;
        do {
            try {
                response = this.getResponse(chain, request, response, true);
                timeoutException = null;
            }
            catch (IOException ioException) {
                timeoutException = ioException;
                response = null;
                if (!this.httpClientConfiguration.shouldRetryOnTimeout()) break;
            }
            boolean bl = isRetryAllowedForRequest && this.needToRetry(requestState, response, timeoutException != null) ? true : (shouldRetry = false);
            if (!shouldRetry) continue;
            this.calculateWaitTime(requestState, response);
            if (this.hasWaitTimeLimitExceeded(requestState)) break;
            this.holdExecution(requestState.currentWaitInMilliSeconds);
            requestState.retryCount++;
        } while (shouldRetry);
        this.requestEntries.remove(request);
        if (timeoutException != null) {
            throw timeoutException;
        }
        return response;
    }

    private Response getResponse(Interceptor.Chain chain, Request request, Response response, boolean shouldCloseResponse) throws IOException {
        try {
            if (shouldCloseResponse && response != null) {
                response.close();
            }
            return chain.proceed(request);
        }
        catch (SocketException socketException) {
            return this.getResponse(chain, request, response, false);
        }
        catch (IOException exception) {
            throw exception;
        }
    }

    private boolean needToRetry(RequestState requestState, Response response, boolean isTimeoutException) {
        boolean isValidAttempt = requestState.retryCount < this.httpClientConfiguration.getNumberOfRetries();
        boolean isValidResponseToRetry = response != null && (this.httpClientConfiguration.getHttpStatusCodesToRetry().contains(response.code()) || this.hasRetryAfterHeader(response));
        return isValidAttempt && (isTimeoutException || isValidResponseToRetry);
    }

    private boolean hasWaitTimeLimitExceeded(RequestState requestState) {
        return this.httpClientConfiguration.getMaximumRetryWaitTime() > 0L && this.toMilliseconds(this.httpClientConfiguration.getMaximumRetryWaitTime()) < requestState.totalWaitTimeInMilliSeconds;
    }

    private void calculateWaitTime(RequestState requestState, Response response) {
        long retryAfterHeaderValue = 0L;
        if (response != null && this.hasRetryAfterHeader(response)) {
            retryAfterHeaderValue = this.getCalculatedHeaderValue(response.header("Retry-After"));
        }
        long calculatedBackOffInMilliSeconds = this.getCalculatedBackOffValue(requestState);
        requestState.currentWaitInMilliSeconds = Math.max(retryAfterHeaderValue, calculatedBackOffInMilliSeconds);
        RequestState requestState2 = requestState;
        requestState2.totalWaitTimeInMilliSeconds = requestState2.totalWaitTimeInMilliSeconds + requestState.currentWaitInMilliSeconds;
    }

    private boolean hasRetryAfterHeader(Response response) {
        String retryAfter = response.header("Retry-After");
        return retryAfter != null && !retryAfter.isEmpty();
    }

    private long getCalculatedHeaderValue(String headerValue) {
        try {
            return this.toMilliseconds(Long.parseLong(headerValue));
        }
        catch (NumberFormatException nfe) {
            long requestAtValueInSeconds = LocalDateTime.parse(headerValue, RFC1123_DATE_TIME_FORMATTER).toEpochSecond(ZoneOffset.UTC);
            long currentDateTimeInSeconds = LocalDateTime.now(ZoneOffset.UTC).toEpochSecond(ZoneOffset.UTC);
            return this.toMilliseconds(requestAtValueInSeconds - currentDateTimeInSeconds);
        }
    }

    private long getCalculatedBackOffValue(RequestState requestState) {
        return (long)((double)(1000L * this.httpClientConfiguration.getRetryInterval()) * Math.pow(this.httpClientConfiguration.getBackOffFactor(), requestState.retryCount) + Math.random() * 100.0);
    }

    private void holdExecution(long milliSeconds) {
        try {
            TimeUnit.MILLISECONDS.sleep(milliSeconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private long toMilliseconds(long seconds) {
        return seconds * 1000L;
    }

    public void addRequestEntry(Request okHttpRequest, RetryConfiguration retryConfiguration) {
        this.requestEntries.put(okHttpRequest, new RequestState(retryConfiguration));
    }

    private RequestState getRequestState(Request okHttpRequest) {
        return (RequestState)this.requestEntries.get(okHttpRequest);
    }

    private class RequestState {
        private int retryCount = 0;
        private long currentWaitInMilliSeconds = 0L;
        private long totalWaitTimeInMilliSeconds = 0L;
        private RetryConfiguration retryConfiguration;

        private RequestState(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
        }
    }
}

