/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ACHDetails {
    private final String routingNumber;
    private final String accountNumberSuffix;
    private final String accountType;

    @JsonCreator
    public ACHDetails(@JsonProperty(value="routing_number") String routingNumber, @JsonProperty(value="account_number_suffix") String accountNumberSuffix, @JsonProperty(value="account_type") String accountType) {
        this.routingNumber = routingNumber;
        this.accountNumberSuffix = accountNumberSuffix;
        this.accountType = accountType;
    }

    @JsonGetter(value="routing_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    @JsonGetter(value="account_number_suffix")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAccountNumberSuffix() {
        return this.accountNumberSuffix;
    }

    @JsonGetter(value="account_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAccountType() {
        return this.accountType;
    }

    public int hashCode() {
        return Objects.hash(this.routingNumber, this.accountNumberSuffix, this.accountType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ACHDetails)) {
            return false;
        }
        ACHDetails other = (ACHDetails)obj;
        return Objects.equals(this.routingNumber, other.routingNumber) && Objects.equals(this.accountNumberSuffix, other.accountNumberSuffix) && Objects.equals(this.accountType, other.accountType);
    }

    public String toString() {
        return "ACHDetails [routingNumber=" + this.routingNumber + ", accountNumberSuffix=" + this.accountNumberSuffix + ", accountType=" + this.accountType + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().routingNumber(this.getRoutingNumber()).accountNumberSuffix(this.getAccountNumberSuffix()).accountType(this.getAccountType());
        return builder;
    }

    public static class Builder {
        private String routingNumber;
        private String accountNumberSuffix;
        private String accountType;

        public Builder routingNumber(String routingNumber) {
            this.routingNumber = routingNumber;
            return this;
        }

        public Builder accountNumberSuffix(String accountNumberSuffix) {
            this.accountNumberSuffix = accountNumberSuffix;
            return this;
        }

        public Builder accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        public ACHDetails build() {
            return new ACHDetails(this.routingNumber, this.accountNumberSuffix, this.accountType);
        }
    }
}

