/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.LoyaltyEventAccumulatePoints;
import java.util.Objects;

public class AccumulateLoyaltyPointsRequest {
    private final LoyaltyEventAccumulatePoints accumulatePoints;
    private final String idempotencyKey;
    private final String locationId;

    @JsonCreator
    public AccumulateLoyaltyPointsRequest(@JsonProperty(value="accumulate_points") LoyaltyEventAccumulatePoints accumulatePoints, @JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="location_id") String locationId) {
        this.accumulatePoints = accumulatePoints;
        this.idempotencyKey = idempotencyKey;
        this.locationId = locationId;
    }

    @JsonGetter(value="accumulate_points")
    public LoyaltyEventAccumulatePoints getAccumulatePoints() {
        return this.accumulatePoints;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    public int hashCode() {
        return Objects.hash(this.accumulatePoints, this.idempotencyKey, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AccumulateLoyaltyPointsRequest)) {
            return false;
        }
        AccumulateLoyaltyPointsRequest other = (AccumulateLoyaltyPointsRequest)obj;
        return Objects.equals(this.accumulatePoints, other.accumulatePoints) && Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "AccumulateLoyaltyPointsRequest [accumulatePoints=" + this.accumulatePoints + ", idempotencyKey=" + this.idempotencyKey + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.accumulatePoints, this.idempotencyKey, this.locationId);
        return builder;
    }

    public static class Builder {
        private LoyaltyEventAccumulatePoints accumulatePoints;
        private String idempotencyKey;
        private String locationId;

        public Builder(LoyaltyEventAccumulatePoints accumulatePoints, String idempotencyKey, String locationId) {
            this.accumulatePoints = accumulatePoints;
            this.idempotencyKey = idempotencyKey;
            this.locationId = locationId;
        }

        public Builder accumulatePoints(LoyaltyEventAccumulatePoints accumulatePoints) {
            this.accumulatePoints = accumulatePoints;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public AccumulateLoyaltyPointsRequest build() {
            return new AccumulateLoyaltyPointsRequest(this.accumulatePoints, this.idempotencyKey, this.locationId);
        }
    }
}

