/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LoyaltyEvent;
import java.util.List;
import java.util.Objects;

public class AccumulateLoyaltyPointsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final LoyaltyEvent event;

    @JsonCreator
    public AccumulateLoyaltyPointsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="event") LoyaltyEvent event) {
        this.errors = errors;
        this.event = event;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="event")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyEvent getEvent() {
        return this.event;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.event);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AccumulateLoyaltyPointsResponse)) {
            return false;
        }
        AccumulateLoyaltyPointsResponse other = (AccumulateLoyaltyPointsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.event, other.event);
    }

    public String toString() {
        return "AccumulateLoyaltyPointsResponse [errors=" + this.errors + ", event=" + this.event + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).event(this.getEvent());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private LoyaltyEvent event;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder event(LoyaltyEvent event) {
            this.event = event;
            return this;
        }

        public AccumulateLoyaltyPointsResponse build() {
            AccumulateLoyaltyPointsResponse model = new AccumulateLoyaltyPointsResponse(this.errors, this.event);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

