/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class AdditionalRecipient {
    private final String locationId;
    private final String description;
    private final Money amountMoney;
    private final String receivableId;

    @JsonCreator
    public AdditionalRecipient(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="description") String description, @JsonProperty(value="receivable_id") String receivableId) {
        this.locationId = locationId;
        this.description = description;
        this.amountMoney = amountMoney;
        this.receivableId = receivableId;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="receivable_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReceivableId() {
        return this.receivableId;
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.description, this.amountMoney, this.receivableId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdditionalRecipient)) {
            return false;
        }
        AdditionalRecipient other = (AdditionalRecipient)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.description, other.description) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.receivableId, other.receivableId);
    }

    public String toString() {
        return "AdditionalRecipient [locationId=" + this.locationId + ", amountMoney=" + this.amountMoney + ", description=" + this.description + ", receivableId=" + this.receivableId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId, this.amountMoney).description(this.getDescription()).receivableId(this.getReceivableId());
        return builder;
    }

    public static class Builder {
        private String locationId;
        private Money amountMoney;
        private String description;
        private String receivableId;

        public Builder(String locationId, Money amountMoney) {
            this.locationId = locationId;
            this.amountMoney = amountMoney;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder receivableId(String receivableId) {
            this.receivableId = receivableId;
            return this;
        }

        public AdditionalRecipient build() {
            return new AdditionalRecipient(this.locationId, this.amountMoney, this.description, this.receivableId);
        }
    }
}

