/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Address {
    private final String addressLine1;
    private final String addressLine2;
    private final String addressLine3;
    private final String locality;
    private final String sublocality;
    private final String administrativeDistrictLevel1;
    private final String postalCode;
    private final String country;

    @JsonCreator
    public Address(@JsonProperty(value="address_line_1") String addressLine1, @JsonProperty(value="address_line_2") String addressLine2, @JsonProperty(value="address_line_3") String addressLine3, @JsonProperty(value="locality") String locality, @JsonProperty(value="sublocality") String sublocality, @JsonProperty(value="administrative_district_level_1") String administrativeDistrictLevel1, @JsonProperty(value="postal_code") String postalCode, @JsonProperty(value="country") String country) {
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.addressLine3 = addressLine3;
        this.locality = locality;
        this.sublocality = sublocality;
        this.administrativeDistrictLevel1 = administrativeDistrictLevel1;
        this.postalCode = postalCode;
        this.country = country;
    }

    @JsonGetter(value="address_line_1")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAddressLine1() {
        return this.addressLine1;
    }

    @JsonGetter(value="address_line_2")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAddressLine2() {
        return this.addressLine2;
    }

    @JsonGetter(value="address_line_3")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAddressLine3() {
        return this.addressLine3;
    }

    @JsonGetter(value="locality")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocality() {
        return this.locality;
    }

    @JsonGetter(value="sublocality")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSublocality() {
        return this.sublocality;
    }

    @JsonGetter(value="administrative_district_level_1")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAdministrativeDistrictLevel1() {
        return this.administrativeDistrictLevel1;
    }

    @JsonGetter(value="postal_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonGetter(value="country")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCountry() {
        return this.country;
    }

    public int hashCode() {
        return Objects.hash(this.addressLine1, this.addressLine2, this.addressLine3, this.locality, this.sublocality, this.administrativeDistrictLevel1, this.postalCode, this.country);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.addressLine1, other.addressLine1) && Objects.equals(this.addressLine2, other.addressLine2) && Objects.equals(this.addressLine3, other.addressLine3) && Objects.equals(this.locality, other.locality) && Objects.equals(this.sublocality, other.sublocality) && Objects.equals(this.administrativeDistrictLevel1, other.administrativeDistrictLevel1) && Objects.equals(this.postalCode, other.postalCode) && Objects.equals(this.country, other.country);
    }

    public String toString() {
        return "Address [addressLine1=" + this.addressLine1 + ", addressLine2=" + this.addressLine2 + ", addressLine3=" + this.addressLine3 + ", locality=" + this.locality + ", sublocality=" + this.sublocality + ", administrativeDistrictLevel1=" + this.administrativeDistrictLevel1 + ", postalCode=" + this.postalCode + ", country=" + this.country + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().addressLine1(this.getAddressLine1()).addressLine2(this.getAddressLine2()).addressLine3(this.getAddressLine3()).locality(this.getLocality()).sublocality(this.getSublocality()).administrativeDistrictLevel1(this.getAdministrativeDistrictLevel1()).postalCode(this.getPostalCode()).country(this.getCountry());
        return builder;
    }

    public static class Builder {
        private String addressLine1;
        private String addressLine2;
        private String addressLine3;
        private String locality;
        private String sublocality;
        private String administrativeDistrictLevel1;
        private String postalCode;
        private String country;

        public Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public Builder addressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder sublocality(String sublocality) {
            this.sublocality = sublocality;
            return this;
        }

        public Builder administrativeDistrictLevel1(String administrativeDistrictLevel1) {
            this.administrativeDistrictLevel1 = administrativeDistrictLevel1;
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Address build() {
            return new Address(this.addressLine1, this.addressLine2, this.addressLine3, this.locality, this.sublocality, this.administrativeDistrictLevel1, this.postalCode, this.country);
        }
    }
}

