/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.LoyaltyEventAdjustPoints;
import java.util.Objects;

public class AdjustLoyaltyPointsRequest {
    private final String idempotencyKey;
    private final LoyaltyEventAdjustPoints adjustPoints;

    @JsonCreator
    public AdjustLoyaltyPointsRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="adjust_points") LoyaltyEventAdjustPoints adjustPoints) {
        this.idempotencyKey = idempotencyKey;
        this.adjustPoints = adjustPoints;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="adjust_points")
    public LoyaltyEventAdjustPoints getAdjustPoints() {
        return this.adjustPoints;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.adjustPoints);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdjustLoyaltyPointsRequest)) {
            return false;
        }
        AdjustLoyaltyPointsRequest other = (AdjustLoyaltyPointsRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.adjustPoints, other.adjustPoints);
    }

    public String toString() {
        return "AdjustLoyaltyPointsRequest [idempotencyKey=" + this.idempotencyKey + ", adjustPoints=" + this.adjustPoints + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.adjustPoints);
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private LoyaltyEventAdjustPoints adjustPoints;

        public Builder(String idempotencyKey, LoyaltyEventAdjustPoints adjustPoints) {
            this.idempotencyKey = idempotencyKey;
            this.adjustPoints = adjustPoints;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder adjustPoints(LoyaltyEventAdjustPoints adjustPoints) {
            this.adjustPoints = adjustPoints;
            return this;
        }

        public AdjustLoyaltyPointsRequest build() {
            return new AdjustLoyaltyPointsRequest(this.idempotencyKey, this.adjustPoints);
        }
    }
}

