/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ApplicationDetails {
    private final String squareProduct;
    private final String applicationId;

    @JsonCreator
    public ApplicationDetails(@JsonProperty(value="square_product") String squareProduct, @JsonProperty(value="application_id") String applicationId) {
        this.squareProduct = squareProduct;
        this.applicationId = applicationId;
    }

    @JsonGetter(value="square_product")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSquareProduct() {
        return this.squareProduct;
    }

    @JsonGetter(value="application_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getApplicationId() {
        return this.applicationId;
    }

    public int hashCode() {
        return Objects.hash(this.squareProduct, this.applicationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationDetails)) {
            return false;
        }
        ApplicationDetails other = (ApplicationDetails)obj;
        return Objects.equals(this.squareProduct, other.squareProduct) && Objects.equals(this.applicationId, other.applicationId);
    }

    public String toString() {
        return "ApplicationDetails [squareProduct=" + this.squareProduct + ", applicationId=" + this.applicationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().squareProduct(this.getSquareProduct()).applicationId(this.getApplicationId());
        return builder;
    }

    public static class Builder {
        private String squareProduct;
        private String applicationId;

        public Builder squareProduct(String squareProduct) {
            this.squareProduct = squareProduct;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public ApplicationDetails build() {
            return new ApplicationDetails(this.squareProduct, this.applicationId);
        }
    }
}

