/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class AppointmentSegment {
    private final Integer durationMinutes;
    private final String serviceVariationId;
    private final String teamMemberId;
    private final long serviceVariationVersion;
    private final Integer intermissionMinutes;
    private final Boolean anyTeamMember;
    private final List<String> resourceIds;

    @JsonCreator
    public AppointmentSegment(@JsonProperty(value="service_variation_id") String serviceVariationId, @JsonProperty(value="team_member_id") String teamMemberId, @JsonProperty(value="service_variation_version") long serviceVariationVersion, @JsonProperty(value="duration_minutes") Integer durationMinutes, @JsonProperty(value="intermission_minutes") Integer intermissionMinutes, @JsonProperty(value="any_team_member") Boolean anyTeamMember, @JsonProperty(value="resource_ids") List<String> resourceIds) {
        this.durationMinutes = durationMinutes;
        this.serviceVariationId = serviceVariationId;
        this.teamMemberId = teamMemberId;
        this.serviceVariationVersion = serviceVariationVersion;
        this.intermissionMinutes = intermissionMinutes;
        this.anyTeamMember = anyTeamMember;
        this.resourceIds = resourceIds;
    }

    @JsonGetter(value="duration_minutes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getDurationMinutes() {
        return this.durationMinutes;
    }

    @JsonGetter(value="service_variation_id")
    public String getServiceVariationId() {
        return this.serviceVariationId;
    }

    @JsonGetter(value="team_member_id")
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonGetter(value="service_variation_version")
    public long getServiceVariationVersion() {
        return this.serviceVariationVersion;
    }

    @JsonGetter(value="intermission_minutes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getIntermissionMinutes() {
        return this.intermissionMinutes;
    }

    @JsonGetter(value="any_team_member")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAnyTeamMember() {
        return this.anyTeamMember;
    }

    @JsonGetter(value="resource_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public int hashCode() {
        return Objects.hash(this.durationMinutes, this.serviceVariationId, this.teamMemberId, this.serviceVariationVersion, this.intermissionMinutes, this.anyTeamMember, this.resourceIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AppointmentSegment)) {
            return false;
        }
        AppointmentSegment other = (AppointmentSegment)obj;
        return Objects.equals(this.durationMinutes, other.durationMinutes) && Objects.equals(this.serviceVariationId, other.serviceVariationId) && Objects.equals(this.teamMemberId, other.teamMemberId) && Objects.equals(this.serviceVariationVersion, other.serviceVariationVersion) && Objects.equals(this.intermissionMinutes, other.intermissionMinutes) && Objects.equals(this.anyTeamMember, other.anyTeamMember) && Objects.equals(this.resourceIds, other.resourceIds);
    }

    public String toString() {
        return "AppointmentSegment [serviceVariationId=" + this.serviceVariationId + ", teamMemberId=" + this.teamMemberId + ", serviceVariationVersion=" + this.serviceVariationVersion + ", durationMinutes=" + this.durationMinutes + ", intermissionMinutes=" + this.intermissionMinutes + ", anyTeamMember=" + this.anyTeamMember + ", resourceIds=" + this.resourceIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.serviceVariationId, this.teamMemberId, this.serviceVariationVersion).durationMinutes(this.getDurationMinutes()).intermissionMinutes(this.getIntermissionMinutes()).anyTeamMember(this.getAnyTeamMember()).resourceIds(this.getResourceIds());
        return builder;
    }

    public static class Builder {
        private String serviceVariationId;
        private String teamMemberId;
        private long serviceVariationVersion;
        private Integer durationMinutes;
        private Integer intermissionMinutes;
        private Boolean anyTeamMember;
        private List<String> resourceIds;

        public Builder(String serviceVariationId, String teamMemberId, long serviceVariationVersion) {
            this.serviceVariationId = serviceVariationId;
            this.teamMemberId = teamMemberId;
            this.serviceVariationVersion = serviceVariationVersion;
        }

        public Builder serviceVariationId(String serviceVariationId) {
            this.serviceVariationId = serviceVariationId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder serviceVariationVersion(long serviceVariationVersion) {
            this.serviceVariationVersion = serviceVariationVersion;
            return this;
        }

        public Builder durationMinutes(Integer durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        public Builder intermissionMinutes(Integer intermissionMinutes) {
            this.intermissionMinutes = intermissionMinutes;
            return this;
        }

        public Builder anyTeamMember(Boolean anyTeamMember) {
            this.anyTeamMember = anyTeamMember;
            return this;
        }

        public Builder resourceIds(List<String> resourceIds) {
            this.resourceIds = resourceIds;
            return this;
        }

        public AppointmentSegment build() {
            return new AppointmentSegment(this.serviceVariationId, this.teamMemberId, this.serviceVariationVersion, this.durationMinutes, this.intermissionMinutes, this.anyTeamMember, this.resourceIds);
        }
    }
}

