/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.AppointmentSegment;
import java.util.List;
import java.util.Objects;

public class Availability {
    private final String startAt;
    private final String locationId;
    private final List<AppointmentSegment> appointmentSegments;

    @JsonCreator
    public Availability(@JsonProperty(value="start_at") String startAt, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="appointment_segments") List<AppointmentSegment> appointmentSegments) {
        this.startAt = startAt;
        this.locationId = locationId;
        this.appointmentSegments = appointmentSegments;
    }

    @JsonGetter(value="start_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStartAt() {
        return this.startAt;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="appointment_segments")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<AppointmentSegment> getAppointmentSegments() {
        return this.appointmentSegments;
    }

    public int hashCode() {
        return Objects.hash(this.startAt, this.locationId, this.appointmentSegments);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Availability)) {
            return false;
        }
        Availability other = (Availability)obj;
        return Objects.equals(this.startAt, other.startAt) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.appointmentSegments, other.appointmentSegments);
    }

    public String toString() {
        return "Availability [startAt=" + this.startAt + ", locationId=" + this.locationId + ", appointmentSegments=" + this.appointmentSegments + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().startAt(this.getStartAt()).locationId(this.getLocationId()).appointmentSegments(this.getAppointmentSegments());
        return builder;
    }

    public static class Builder {
        private String startAt;
        private String locationId;
        private List<AppointmentSegment> appointmentSegments;

        public Builder startAt(String startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder appointmentSegments(List<AppointmentSegment> appointmentSegments) {
            this.appointmentSegments = appointmentSegments;
            return this;
        }

        public Availability build() {
            return new Availability(this.startAt, this.locationId, this.appointmentSegments);
        }
    }
}

