/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class BankAccount {
    private final String id;
    private final String accountNumberSuffix;
    private final String country;
    private final String currency;
    private final String accountType;
    private final String holderName;
    private final String primaryBankIdentificationNumber;
    private final String secondaryBankIdentificationNumber;
    private final String debitMandateReferenceId;
    private final String referenceId;
    private final String locationId;
    private final String status;
    private final boolean creditable;
    private final boolean debitable;
    private final String fingerprint;
    private final Integer version;
    private final String bankName;

    @JsonCreator
    public BankAccount(@JsonProperty(value="id") String id, @JsonProperty(value="account_number_suffix") String accountNumberSuffix, @JsonProperty(value="country") String country, @JsonProperty(value="currency") String currency, @JsonProperty(value="account_type") String accountType, @JsonProperty(value="holder_name") String holderName, @JsonProperty(value="primary_bank_identification_number") String primaryBankIdentificationNumber, @JsonProperty(value="status") String status, @JsonProperty(value="creditable") boolean creditable, @JsonProperty(value="debitable") boolean debitable, @JsonProperty(value="secondary_bank_identification_number") String secondaryBankIdentificationNumber, @JsonProperty(value="debit_mandate_reference_id") String debitMandateReferenceId, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="fingerprint") String fingerprint, @JsonProperty(value="version") Integer version, @JsonProperty(value="bank_name") String bankName) {
        this.id = id;
        this.accountNumberSuffix = accountNumberSuffix;
        this.country = country;
        this.currency = currency;
        this.accountType = accountType;
        this.holderName = holderName;
        this.primaryBankIdentificationNumber = primaryBankIdentificationNumber;
        this.secondaryBankIdentificationNumber = secondaryBankIdentificationNumber;
        this.debitMandateReferenceId = debitMandateReferenceId;
        this.referenceId = referenceId;
        this.locationId = locationId;
        this.status = status;
        this.creditable = creditable;
        this.debitable = debitable;
        this.fingerprint = fingerprint;
        this.version = version;
        this.bankName = bankName;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="account_number_suffix")
    public String getAccountNumberSuffix() {
        return this.accountNumberSuffix;
    }

    @JsonGetter(value="country")
    public String getCountry() {
        return this.country;
    }

    @JsonGetter(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonGetter(value="account_type")
    public String getAccountType() {
        return this.accountType;
    }

    @JsonGetter(value="holder_name")
    public String getHolderName() {
        return this.holderName;
    }

    @JsonGetter(value="primary_bank_identification_number")
    public String getPrimaryBankIdentificationNumber() {
        return this.primaryBankIdentificationNumber;
    }

    @JsonGetter(value="secondary_bank_identification_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSecondaryBankIdentificationNumber() {
        return this.secondaryBankIdentificationNumber;
    }

    @JsonGetter(value="debit_mandate_reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDebitMandateReferenceId() {
        return this.debitMandateReferenceId;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="creditable")
    public boolean getCreditable() {
        return this.creditable;
    }

    @JsonGetter(value="debitable")
    public boolean getDebitable() {
        return this.debitable;
    }

    @JsonGetter(value="fingerprint")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFingerprint() {
        return this.fingerprint;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="bank_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBankName() {
        return this.bankName;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.accountNumberSuffix, this.country, this.currency, this.accountType, this.holderName, this.primaryBankIdentificationNumber, this.secondaryBankIdentificationNumber, this.debitMandateReferenceId, this.referenceId, this.locationId, this.status, this.creditable, this.debitable, this.fingerprint, this.version, this.bankName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BankAccount)) {
            return false;
        }
        BankAccount other = (BankAccount)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.accountNumberSuffix, other.accountNumberSuffix) && Objects.equals(this.country, other.country) && Objects.equals(this.currency, other.currency) && Objects.equals(this.accountType, other.accountType) && Objects.equals(this.holderName, other.holderName) && Objects.equals(this.primaryBankIdentificationNumber, other.primaryBankIdentificationNumber) && Objects.equals(this.secondaryBankIdentificationNumber, other.secondaryBankIdentificationNumber) && Objects.equals(this.debitMandateReferenceId, other.debitMandateReferenceId) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.status, other.status) && Objects.equals(this.creditable, other.creditable) && Objects.equals(this.debitable, other.debitable) && Objects.equals(this.fingerprint, other.fingerprint) && Objects.equals(this.version, other.version) && Objects.equals(this.bankName, other.bankName);
    }

    public String toString() {
        return "BankAccount [id=" + this.id + ", accountNumberSuffix=" + this.accountNumberSuffix + ", country=" + this.country + ", currency=" + this.currency + ", accountType=" + this.accountType + ", holderName=" + this.holderName + ", primaryBankIdentificationNumber=" + this.primaryBankIdentificationNumber + ", status=" + this.status + ", creditable=" + this.creditable + ", debitable=" + this.debitable + ", secondaryBankIdentificationNumber=" + this.secondaryBankIdentificationNumber + ", debitMandateReferenceId=" + this.debitMandateReferenceId + ", referenceId=" + this.referenceId + ", locationId=" + this.locationId + ", fingerprint=" + this.fingerprint + ", version=" + this.version + ", bankName=" + this.bankName + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.accountNumberSuffix, this.country, this.currency, this.accountType, this.holderName, this.primaryBankIdentificationNumber, this.status, this.creditable, this.debitable).secondaryBankIdentificationNumber(this.getSecondaryBankIdentificationNumber()).debitMandateReferenceId(this.getDebitMandateReferenceId()).referenceId(this.getReferenceId()).locationId(this.getLocationId()).fingerprint(this.getFingerprint()).version(this.getVersion()).bankName(this.getBankName());
        return builder;
    }

    public static class Builder {
        private String id;
        private String accountNumberSuffix;
        private String country;
        private String currency;
        private String accountType;
        private String holderName;
        private String primaryBankIdentificationNumber;
        private String status;
        private boolean creditable;
        private boolean debitable;
        private String secondaryBankIdentificationNumber;
        private String debitMandateReferenceId;
        private String referenceId;
        private String locationId;
        private String fingerprint;
        private Integer version;
        private String bankName;

        public Builder(String id, String accountNumberSuffix, String country, String currency, String accountType, String holderName, String primaryBankIdentificationNumber, String status, boolean creditable, boolean debitable) {
            this.id = id;
            this.accountNumberSuffix = accountNumberSuffix;
            this.country = country;
            this.currency = currency;
            this.accountType = accountType;
            this.holderName = holderName;
            this.primaryBankIdentificationNumber = primaryBankIdentificationNumber;
            this.status = status;
            this.creditable = creditable;
            this.debitable = debitable;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder accountNumberSuffix(String accountNumberSuffix) {
            this.accountNumberSuffix = accountNumberSuffix;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        public Builder holderName(String holderName) {
            this.holderName = holderName;
            return this;
        }

        public Builder primaryBankIdentificationNumber(String primaryBankIdentificationNumber) {
            this.primaryBankIdentificationNumber = primaryBankIdentificationNumber;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder creditable(boolean creditable) {
            this.creditable = creditable;
            return this;
        }

        public Builder debitable(boolean debitable) {
            this.debitable = debitable;
            return this;
        }

        public Builder secondaryBankIdentificationNumber(String secondaryBankIdentificationNumber) {
            this.secondaryBankIdentificationNumber = secondaryBankIdentificationNumber;
            return this;
        }

        public Builder debitMandateReferenceId(String debitMandateReferenceId) {
            this.debitMandateReferenceId = debitMandateReferenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        public BankAccount build() {
            return new BankAccount(this.id, this.accountNumberSuffix, this.country, this.currency, this.accountType, this.holderName, this.primaryBankIdentificationNumber, this.status, this.creditable, this.debitable, this.secondaryBankIdentificationNumber, this.debitMandateReferenceId, this.referenceId, this.locationId, this.fingerprint, this.version, this.bankName);
        }
    }
}

