/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.ACHDetails;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class BankAccountPaymentDetails {
    private final String bankName;
    private final String transferType;
    private final String accountOwnershipType;
    private final String fingerprint;
    private final String country;
    private final String statementDescription;
    private final ACHDetails achDetails;
    private final List<Error> errors;

    @JsonCreator
    public BankAccountPaymentDetails(@JsonProperty(value="bank_name") String bankName, @JsonProperty(value="transfer_type") String transferType, @JsonProperty(value="account_ownership_type") String accountOwnershipType, @JsonProperty(value="fingerprint") String fingerprint, @JsonProperty(value="country") String country, @JsonProperty(value="statement_description") String statementDescription, @JsonProperty(value="ach_details") ACHDetails achDetails, @JsonProperty(value="errors") List<Error> errors) {
        this.bankName = bankName;
        this.transferType = transferType;
        this.accountOwnershipType = accountOwnershipType;
        this.fingerprint = fingerprint;
        this.country = country;
        this.statementDescription = statementDescription;
        this.achDetails = achDetails;
        this.errors = errors;
    }

    @JsonGetter(value="bank_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBankName() {
        return this.bankName;
    }

    @JsonGetter(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTransferType() {
        return this.transferType;
    }

    @JsonGetter(value="account_ownership_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAccountOwnershipType() {
        return this.accountOwnershipType;
    }

    @JsonGetter(value="fingerprint")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFingerprint() {
        return this.fingerprint;
    }

    @JsonGetter(value="country")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCountry() {
        return this.country;
    }

    @JsonGetter(value="statement_description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @JsonGetter(value="ach_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ACHDetails getAchDetails() {
        return this.achDetails;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.bankName, this.transferType, this.accountOwnershipType, this.fingerprint, this.country, this.statementDescription, this.achDetails, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BankAccountPaymentDetails)) {
            return false;
        }
        BankAccountPaymentDetails other = (BankAccountPaymentDetails)obj;
        return Objects.equals(this.bankName, other.bankName) && Objects.equals(this.transferType, other.transferType) && Objects.equals(this.accountOwnershipType, other.accountOwnershipType) && Objects.equals(this.fingerprint, other.fingerprint) && Objects.equals(this.country, other.country) && Objects.equals(this.statementDescription, other.statementDescription) && Objects.equals(this.achDetails, other.achDetails) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "BankAccountPaymentDetails [bankName=" + this.bankName + ", transferType=" + this.transferType + ", accountOwnershipType=" + this.accountOwnershipType + ", fingerprint=" + this.fingerprint + ", country=" + this.country + ", statementDescription=" + this.statementDescription + ", achDetails=" + this.achDetails + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().bankName(this.getBankName()).transferType(this.getTransferType()).accountOwnershipType(this.getAccountOwnershipType()).fingerprint(this.getFingerprint()).country(this.getCountry()).statementDescription(this.getStatementDescription()).achDetails(this.getAchDetails()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private String bankName;
        private String transferType;
        private String accountOwnershipType;
        private String fingerprint;
        private String country;
        private String statementDescription;
        private ACHDetails achDetails;
        private List<Error> errors;

        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        public Builder transferType(String transferType) {
            this.transferType = transferType;
            return this;
        }

        public Builder accountOwnershipType(String accountOwnershipType) {
            this.accountOwnershipType = accountOwnershipType;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder statementDescription(String statementDescription) {
            this.statementDescription = statementDescription;
            return this;
        }

        public Builder achDetails(ACHDetails achDetails) {
            this.achDetails = achDetails;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public BankAccountPaymentDetails build() {
            return new BankAccountPaymentDetails(this.bankName, this.transferType, this.accountOwnershipType, this.fingerprint, this.country, this.statementDescription, this.achDetails, this.errors);
        }
    }
}

