/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class BatchDeleteCatalogObjectsRequest {
    private final List<String> objectIds;

    @JsonCreator
    public BatchDeleteCatalogObjectsRequest(@JsonProperty(value="object_ids") List<String> objectIds) {
        this.objectIds = objectIds;
    }

    @JsonGetter(value="object_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getObjectIds() {
        return this.objectIds;
    }

    public int hashCode() {
        return Objects.hash(this.objectIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchDeleteCatalogObjectsRequest)) {
            return false;
        }
        BatchDeleteCatalogObjectsRequest other = (BatchDeleteCatalogObjectsRequest)obj;
        return Objects.equals(this.objectIds, other.objectIds);
    }

    public String toString() {
        return "BatchDeleteCatalogObjectsRequest [objectIds=" + this.objectIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().objectIds(this.getObjectIds());
        return builder;
    }

    public static class Builder {
        private List<String> objectIds;

        public Builder objectIds(List<String> objectIds) {
            this.objectIds = objectIds;
            return this;
        }

        public BatchDeleteCatalogObjectsRequest build() {
            return new BatchDeleteCatalogObjectsRequest(this.objectIds);
        }
    }
}

