/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class BatchRetrieveCatalogObjectsRequest {
    private final List<String> objectIds;
    private final Boolean includeRelatedObjects;
    private final Long catalogVersion;
    private final Boolean includeDeletedObjects;

    @JsonCreator
    public BatchRetrieveCatalogObjectsRequest(@JsonProperty(value="object_ids") List<String> objectIds, @JsonProperty(value="include_related_objects") Boolean includeRelatedObjects, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="include_deleted_objects") Boolean includeDeletedObjects) {
        this.objectIds = objectIds;
        this.includeRelatedObjects = includeRelatedObjects;
        this.catalogVersion = catalogVersion;
        this.includeDeletedObjects = includeDeletedObjects;
    }

    @JsonGetter(value="object_ids")
    public List<String> getObjectIds() {
        return this.objectIds;
    }

    @JsonGetter(value="include_related_objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIncludeRelatedObjects() {
        return this.includeRelatedObjects;
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonGetter(value="include_deleted_objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIncludeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    public int hashCode() {
        return Objects.hash(this.objectIds, this.includeRelatedObjects, this.catalogVersion, this.includeDeletedObjects);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchRetrieveCatalogObjectsRequest)) {
            return false;
        }
        BatchRetrieveCatalogObjectsRequest other = (BatchRetrieveCatalogObjectsRequest)obj;
        return Objects.equals(this.objectIds, other.objectIds) && Objects.equals(this.includeRelatedObjects, other.includeRelatedObjects) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.includeDeletedObjects, other.includeDeletedObjects);
    }

    public String toString() {
        return "BatchRetrieveCatalogObjectsRequest [objectIds=" + this.objectIds + ", includeRelatedObjects=" + this.includeRelatedObjects + ", catalogVersion=" + this.catalogVersion + ", includeDeletedObjects=" + this.includeDeletedObjects + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.objectIds).includeRelatedObjects(this.getIncludeRelatedObjects()).catalogVersion(this.getCatalogVersion()).includeDeletedObjects(this.getIncludeDeletedObjects());
        return builder;
    }

    public static class Builder {
        private List<String> objectIds;
        private Boolean includeRelatedObjects;
        private Long catalogVersion;
        private Boolean includeDeletedObjects;

        public Builder(List<String> objectIds) {
            this.objectIds = objectIds;
        }

        public Builder objectIds(List<String> objectIds) {
            this.objectIds = objectIds;
            return this;
        }

        public Builder includeRelatedObjects(Boolean includeRelatedObjects) {
            this.includeRelatedObjects = includeRelatedObjects;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder includeDeletedObjects(Boolean includeDeletedObjects) {
            this.includeDeletedObjects = includeDeletedObjects;
            return this;
        }

        public BatchRetrieveCatalogObjectsRequest build() {
            return new BatchRetrieveCatalogObjectsRequest(this.objectIds, this.includeRelatedObjects, this.catalogVersion, this.includeDeletedObjects);
        }
    }
}

