/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class BatchRetrieveInventoryChangesRequest {
    private final List<String> catalogObjectIds;
    private final List<String> locationIds;
    private final List<String> types;
    private final List<String> states;
    private final String updatedAfter;
    private final String updatedBefore;
    private final String cursor;

    @JsonCreator
    public BatchRetrieveInventoryChangesRequest(@JsonProperty(value="catalog_object_ids") List<String> catalogObjectIds, @JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="types") List<String> types, @JsonProperty(value="states") List<String> states, @JsonProperty(value="updated_after") String updatedAfter, @JsonProperty(value="updated_before") String updatedBefore, @JsonProperty(value="cursor") String cursor) {
        this.catalogObjectIds = catalogObjectIds;
        this.locationIds = locationIds;
        this.types = types;
        this.states = states;
        this.updatedAfter = updatedAfter;
        this.updatedBefore = updatedBefore;
        this.cursor = cursor;
    }

    @JsonGetter(value="catalog_object_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getCatalogObjectIds() {
        return this.catalogObjectIds;
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    @JsonGetter(value="types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getTypes() {
        return this.types;
    }

    @JsonGetter(value="states")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getStates() {
        return this.states;
    }

    @JsonGetter(value="updated_after")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAfter() {
        return this.updatedAfter;
    }

    @JsonGetter(value="updated_before")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedBefore() {
        return this.updatedBefore;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectIds, this.locationIds, this.types, this.states, this.updatedAfter, this.updatedBefore, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchRetrieveInventoryChangesRequest)) {
            return false;
        }
        BatchRetrieveInventoryChangesRequest other = (BatchRetrieveInventoryChangesRequest)obj;
        return Objects.equals(this.catalogObjectIds, other.catalogObjectIds) && Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.types, other.types) && Objects.equals(this.states, other.states) && Objects.equals(this.updatedAfter, other.updatedAfter) && Objects.equals(this.updatedBefore, other.updatedBefore) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "BatchRetrieveInventoryChangesRequest [catalogObjectIds=" + this.catalogObjectIds + ", locationIds=" + this.locationIds + ", types=" + this.types + ", states=" + this.states + ", updatedAfter=" + this.updatedAfter + ", updatedBefore=" + this.updatedBefore + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().catalogObjectIds(this.getCatalogObjectIds()).locationIds(this.getLocationIds()).types(this.getTypes()).states(this.getStates()).updatedAfter(this.getUpdatedAfter()).updatedBefore(this.getUpdatedBefore()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private List<String> catalogObjectIds;
        private List<String> locationIds;
        private List<String> types;
        private List<String> states;
        private String updatedAfter;
        private String updatedBefore;
        private String cursor;

        public Builder catalogObjectIds(List<String> catalogObjectIds) {
            this.catalogObjectIds = catalogObjectIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder types(List<String> types) {
            this.types = types;
            return this;
        }

        public Builder states(List<String> states) {
            this.states = states;
            return this;
        }

        public Builder updatedAfter(String updatedAfter) {
            this.updatedAfter = updatedAfter;
            return this;
        }

        public Builder updatedBefore(String updatedBefore) {
            this.updatedBefore = updatedBefore;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public BatchRetrieveInventoryChangesRequest build() {
            return new BatchRetrieveInventoryChangesRequest(this.catalogObjectIds, this.locationIds, this.types, this.states, this.updatedAfter, this.updatedBefore, this.cursor);
        }
    }
}

