/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class BatchRetrieveInventoryCountsRequest {
    private final List<String> catalogObjectIds;
    private final List<String> locationIds;
    private final String updatedAfter;
    private final String cursor;
    private final List<String> states;

    @JsonCreator
    public BatchRetrieveInventoryCountsRequest(@JsonProperty(value="catalog_object_ids") List<String> catalogObjectIds, @JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="updated_after") String updatedAfter, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="states") List<String> states) {
        this.catalogObjectIds = catalogObjectIds;
        this.locationIds = locationIds;
        this.updatedAfter = updatedAfter;
        this.cursor = cursor;
        this.states = states;
    }

    @JsonGetter(value="catalog_object_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getCatalogObjectIds() {
        return this.catalogObjectIds;
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    @JsonGetter(value="updated_after")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAfter() {
        return this.updatedAfter;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="states")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getStates() {
        return this.states;
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectIds, this.locationIds, this.updatedAfter, this.cursor, this.states);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchRetrieveInventoryCountsRequest)) {
            return false;
        }
        BatchRetrieveInventoryCountsRequest other = (BatchRetrieveInventoryCountsRequest)obj;
        return Objects.equals(this.catalogObjectIds, other.catalogObjectIds) && Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.updatedAfter, other.updatedAfter) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.states, other.states);
    }

    public String toString() {
        return "BatchRetrieveInventoryCountsRequest [catalogObjectIds=" + this.catalogObjectIds + ", locationIds=" + this.locationIds + ", updatedAfter=" + this.updatedAfter + ", cursor=" + this.cursor + ", states=" + this.states + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().catalogObjectIds(this.getCatalogObjectIds()).locationIds(this.getLocationIds()).updatedAfter(this.getUpdatedAfter()).cursor(this.getCursor()).states(this.getStates());
        return builder;
    }

    public static class Builder {
        private List<String> catalogObjectIds;
        private List<String> locationIds;
        private String updatedAfter;
        private String cursor;
        private List<String> states;

        public Builder catalogObjectIds(List<String> catalogObjectIds) {
            this.catalogObjectIds = catalogObjectIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder updatedAfter(String updatedAfter) {
            this.updatedAfter = updatedAfter;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder states(List<String> states) {
            this.states = states;
            return this;
        }

        public BatchRetrieveInventoryCountsRequest build() {
            return new BatchRetrieveInventoryCountsRequest(this.catalogObjectIds, this.locationIds, this.updatedAfter, this.cursor, this.states);
        }
    }
}

