/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class BatchRetrieveOrdersRequest {
    private final String locationId;
    private final List<String> orderIds;

    @JsonCreator
    public BatchRetrieveOrdersRequest(@JsonProperty(value="order_ids") List<String> orderIds, @JsonProperty(value="location_id") String locationId) {
        this.locationId = locationId;
        this.orderIds = orderIds;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="order_ids")
    public List<String> getOrderIds() {
        return this.orderIds;
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.orderIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchRetrieveOrdersRequest)) {
            return false;
        }
        BatchRetrieveOrdersRequest other = (BatchRetrieveOrdersRequest)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.orderIds, other.orderIds);
    }

    public String toString() {
        return "BatchRetrieveOrdersRequest [orderIds=" + this.orderIds + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.orderIds).locationId(this.getLocationId());
        return builder;
    }

    public static class Builder {
        private List<String> orderIds;
        private String locationId;

        public Builder(List<String> orderIds) {
            this.orderIds = orderIds;
        }

        public Builder orderIds(List<String> orderIds) {
            this.orderIds = orderIds;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public BatchRetrieveOrdersRequest build() {
            return new BatchRetrieveOrdersRequest(this.orderIds, this.locationId);
        }
    }
}

