/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Order;
import java.util.List;
import java.util.Objects;

public class BatchRetrieveOrdersResponse {
    private HttpContext httpContext;
    private final List<Order> orders;
    private final List<Error> errors;

    @JsonCreator
    public BatchRetrieveOrdersResponse(@JsonProperty(value="orders") List<Order> orders, @JsonProperty(value="errors") List<Error> errors) {
        this.orders = orders;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="orders")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Order> getOrders() {
        return this.orders;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.orders, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchRetrieveOrdersResponse)) {
            return false;
        }
        BatchRetrieveOrdersResponse other = (BatchRetrieveOrdersResponse)obj;
        return Objects.equals(this.orders, other.orders) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "BatchRetrieveOrdersResponse [orders=" + this.orders + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().orders(this.getOrders()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Order> orders;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder orders(List<Order> orders) {
            this.orders = orders;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public BatchRetrieveOrdersResponse build() {
            BatchRetrieveOrdersResponse model = new BatchRetrieveOrdersResponse(this.orders, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

