/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CatalogIdMapping;
import com.squareup.square.models.CatalogObject;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class BatchUpsertCatalogObjectsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<CatalogObject> objects;
    private final String updatedAt;
    private final List<CatalogIdMapping> idMappings;

    @JsonCreator
    public BatchUpsertCatalogObjectsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="objects") List<CatalogObject> objects, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="id_mappings") List<CatalogIdMapping> idMappings) {
        this.errors = errors;
        this.objects = objects;
        this.updatedAt = updatedAt;
        this.idMappings = idMappings;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogObject> getObjects() {
        return this.objects;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="id_mappings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogIdMapping> getIdMappings() {
        return this.idMappings;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.objects, this.updatedAt, this.idMappings);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchUpsertCatalogObjectsResponse)) {
            return false;
        }
        BatchUpsertCatalogObjectsResponse other = (BatchUpsertCatalogObjectsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.objects, other.objects) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.idMappings, other.idMappings);
    }

    public String toString() {
        return "BatchUpsertCatalogObjectsResponse [errors=" + this.errors + ", objects=" + this.objects + ", updatedAt=" + this.updatedAt + ", idMappings=" + this.idMappings + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).objects(this.getObjects()).updatedAt(this.getUpdatedAt()).idMappings(this.getIdMappings());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<CatalogObject> objects;
        private String updatedAt;
        private List<CatalogIdMapping> idMappings;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder objects(List<CatalogObject> objects) {
            this.objects = objects;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder idMappings(List<CatalogIdMapping> idMappings) {
            this.idMappings = idMappings;
            return this;
        }

        public BatchUpsertCatalogObjectsResponse build() {
            BatchUpsertCatalogObjectsResponse model = new BatchUpsertCatalogObjectsResponse(this.errors, this.objects, this.updatedAt, this.idMappings);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

