/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class BookingCreatorDetails {
    private final String creatorType;
    private final String teamMemberId;
    private final String customerId;

    @JsonCreator
    public BookingCreatorDetails(@JsonProperty(value="creator_type") String creatorType, @JsonProperty(value="team_member_id") String teamMemberId, @JsonProperty(value="customer_id") String customerId) {
        this.creatorType = creatorType;
        this.teamMemberId = teamMemberId;
        this.customerId = customerId;
    }

    @JsonGetter(value="creator_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatorType() {
        return this.creatorType;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    public int hashCode() {
        return Objects.hash(this.creatorType, this.teamMemberId, this.customerId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BookingCreatorDetails)) {
            return false;
        }
        BookingCreatorDetails other = (BookingCreatorDetails)obj;
        return Objects.equals(this.creatorType, other.creatorType) && Objects.equals(this.teamMemberId, other.teamMemberId) && Objects.equals(this.customerId, other.customerId);
    }

    public String toString() {
        return "BookingCreatorDetails [creatorType=" + this.creatorType + ", teamMemberId=" + this.teamMemberId + ", customerId=" + this.customerId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().creatorType(this.getCreatorType()).teamMemberId(this.getTeamMemberId()).customerId(this.getCustomerId());
        return builder;
    }

    public static class Builder {
        private String creatorType;
        private String teamMemberId;
        private String customerId;

        public Builder creatorType(String creatorType) {
            this.creatorType = creatorType;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public BookingCreatorDetails build() {
            return new BookingCreatorDetails(this.creatorType, this.teamMemberId, this.customerId);
        }
    }
}

