/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class BreakType {
    private final String id;
    private final String locationId;
    private final String breakName;
    private final String expectedDuration;
    private final boolean isPaid;
    private final Integer version;
    private final String createdAt;
    private final String updatedAt;

    @JsonCreator
    public BreakType(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="break_name") String breakName, @JsonProperty(value="expected_duration") String expectedDuration, @JsonProperty(value="is_paid") boolean isPaid, @JsonProperty(value="id") String id, @JsonProperty(value="version") Integer version, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt) {
        this.id = id;
        this.locationId = locationId;
        this.breakName = breakName;
        this.expectedDuration = expectedDuration;
        this.isPaid = isPaid;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="break_name")
    public String getBreakName() {
        return this.breakName;
    }

    @JsonGetter(value="expected_duration")
    public String getExpectedDuration() {
        return this.expectedDuration;
    }

    @JsonGetter(value="is_paid")
    public boolean getIsPaid() {
        return this.isPaid;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.breakName, this.expectedDuration, this.isPaid, this.version, this.createdAt, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BreakType)) {
            return false;
        }
        BreakType other = (BreakType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.breakName, other.breakName) && Objects.equals(this.expectedDuration, other.expectedDuration) && Objects.equals(this.isPaid, other.isPaid) && Objects.equals(this.version, other.version) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "BreakType [locationId=" + this.locationId + ", breakName=" + this.breakName + ", expectedDuration=" + this.expectedDuration + ", isPaid=" + this.isPaid + ", id=" + this.id + ", version=" + this.version + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId, this.breakName, this.expectedDuration, this.isPaid).id(this.getId()).version(this.getVersion()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        return builder;
    }

    public static class Builder {
        private String locationId;
        private String breakName;
        private String expectedDuration;
        private boolean isPaid;
        private String id;
        private Integer version;
        private String createdAt;
        private String updatedAt;

        public Builder(String locationId, String breakName, String expectedDuration, boolean isPaid) {
            this.locationId = locationId;
            this.breakName = breakName;
            this.expectedDuration = expectedDuration;
            this.isPaid = isPaid;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder breakName(String breakName) {
            this.breakName = breakName;
            return this;
        }

        public Builder expectedDuration(String expectedDuration) {
            this.expectedDuration = expectedDuration;
            return this;
        }

        public Builder isPaid(boolean isPaid) {
            this.isPaid = isPaid;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public BreakType build() {
            return new BreakType(this.locationId, this.breakName, this.expectedDuration, this.isPaid, this.id, this.version, this.createdAt, this.updatedAt);
        }
    }
}

