/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CreateTeamMemberResponse;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BulkCreateTeamMembersResponse {
    private HttpContext httpContext;
    private final Map<String, CreateTeamMemberResponse> teamMembers;
    private final List<Error> errors;

    @JsonCreator
    public BulkCreateTeamMembersResponse(@JsonProperty(value="team_members") Map<String, CreateTeamMemberResponse> teamMembers, @JsonProperty(value="errors") List<Error> errors) {
        this.teamMembers = teamMembers;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="team_members")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, CreateTeamMemberResponse> getTeamMembers() {
        return this.teamMembers;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.teamMembers, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkCreateTeamMembersResponse)) {
            return false;
        }
        BulkCreateTeamMembersResponse other = (BulkCreateTeamMembersResponse)obj;
        return Objects.equals(this.teamMembers, other.teamMembers) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "BulkCreateTeamMembersResponse [teamMembers=" + this.teamMembers + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().teamMembers(this.getTeamMembers()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private Map<String, CreateTeamMemberResponse> teamMembers;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder teamMembers(Map<String, CreateTeamMemberResponse> teamMembers) {
            this.teamMembers = teamMembers;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public BulkCreateTeamMembersResponse build() {
            BulkCreateTeamMembersResponse model = new BulkCreateTeamMembersResponse(this.teamMembers, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

