/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class BulkRetrieveVendorsRequest {
    private final List<String> vendorIds;

    @JsonCreator
    public BulkRetrieveVendorsRequest(@JsonProperty(value="vendor_ids") List<String> vendorIds) {
        this.vendorIds = vendorIds;
    }

    @JsonGetter(value="vendor_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getVendorIds() {
        return this.vendorIds;
    }

    public int hashCode() {
        return Objects.hash(this.vendorIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkRetrieveVendorsRequest)) {
            return false;
        }
        BulkRetrieveVendorsRequest other = (BulkRetrieveVendorsRequest)obj;
        return Objects.equals(this.vendorIds, other.vendorIds);
    }

    public String toString() {
        return "BulkRetrieveVendorsRequest [vendorIds=" + this.vendorIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().vendorIds(this.getVendorIds());
        return builder;
    }

    public static class Builder {
        private List<String> vendorIds;

        public Builder vendorIds(List<String> vendorIds) {
            this.vendorIds = vendorIds;
            return this;
        }

        public BulkRetrieveVendorsRequest build() {
            return new BulkRetrieveVendorsRequest(this.vendorIds);
        }
    }
}

