/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.UpdateVendorResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BulkUpdateVendorsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Map<String, UpdateVendorResponse> responses;

    @JsonCreator
    public BulkUpdateVendorsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="responses") Map<String, UpdateVendorResponse> responses) {
        this.errors = errors;
        this.responses = responses;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="responses")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, UpdateVendorResponse> getResponses() {
        return this.responses;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.responses);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkUpdateVendorsResponse)) {
            return false;
        }
        BulkUpdateVendorsResponse other = (BulkUpdateVendorsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.responses, other.responses);
    }

    public String toString() {
        return "BulkUpdateVendorsResponse [errors=" + this.errors + ", responses=" + this.responses + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).responses(this.getResponses());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Map<String, UpdateVendorResponse> responses;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder responses(Map<String, UpdateVendorResponse> responses) {
            this.responses = responses;
            return this;
        }

        public BulkUpdateVendorsResponse build() {
            BulkUpdateVendorsResponse model = new BulkUpdateVendorsResponse(this.errors, this.responses);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

