/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomAttribute;
import java.util.Objects;

public class BulkUpsertCustomerCustomAttributesRequestCustomerCustomAttributeUpsertRequest {
    private final String customerId;
    private final CustomAttribute customAttribute;
    private final String idempotencyKey;

    @JsonCreator
    public BulkUpsertCustomerCustomAttributesRequestCustomerCustomAttributeUpsertRequest(@JsonProperty(value="customer_id") String customerId, @JsonProperty(value="custom_attribute") CustomAttribute customAttribute, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.customerId = customerId;
        this.customAttribute = customAttribute;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="custom_attribute")
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.customAttribute, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkUpsertCustomerCustomAttributesRequestCustomerCustomAttributeUpsertRequest)) {
            return false;
        }
        BulkUpsertCustomerCustomAttributesRequestCustomerCustomAttributeUpsertRequest other = (BulkUpsertCustomerCustomAttributesRequestCustomerCustomAttributeUpsertRequest)obj;
        return Objects.equals(this.customerId, other.customerId) && Objects.equals(this.customAttribute, other.customAttribute) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "BulkUpsertCustomerCustomAttributesRequestCustomerCustomAttributeUpsertRequest [customerId=" + this.customerId + ", customAttribute=" + this.customAttribute + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.customerId, this.customAttribute).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private String customerId;
        private CustomAttribute customAttribute;
        private String idempotencyKey;

        public Builder(String customerId, CustomAttribute customAttribute) {
            this.customerId = customerId;
            this.customAttribute = customAttribute;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customAttribute(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public BulkUpsertCustomerCustomAttributesRequestCustomerCustomAttributeUpsertRequest build() {
            return new BulkUpsertCustomerCustomAttributesRequestCustomerCustomAttributeUpsertRequest(this.customerId, this.customAttribute, this.idempotencyKey);
        }
    }
}

