/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.List;
import java.util.Objects;

public class BusinessAppointmentSettings {
    private final List<String> locationTypes;
    private final String alignmentTime;
    private final Integer minBookingLeadTimeSeconds;
    private final Integer maxBookingLeadTimeSeconds;
    private final Boolean anyTeamMemberBookingEnabled;
    private final Boolean multipleServiceBookingEnabled;
    private final String maxAppointmentsPerDayLimitType;
    private final Integer maxAppointmentsPerDayLimit;
    private final Integer cancellationWindowSeconds;
    private final Money cancellationFeeMoney;
    private final String cancellationPolicy;
    private final String cancellationPolicyText;
    private final Boolean skipBookingFlowStaffSelection;

    @JsonCreator
    public BusinessAppointmentSettings(@JsonProperty(value="location_types") List<String> locationTypes, @JsonProperty(value="alignment_time") String alignmentTime, @JsonProperty(value="min_booking_lead_time_seconds") Integer minBookingLeadTimeSeconds, @JsonProperty(value="max_booking_lead_time_seconds") Integer maxBookingLeadTimeSeconds, @JsonProperty(value="any_team_member_booking_enabled") Boolean anyTeamMemberBookingEnabled, @JsonProperty(value="multiple_service_booking_enabled") Boolean multipleServiceBookingEnabled, @JsonProperty(value="max_appointments_per_day_limit_type") String maxAppointmentsPerDayLimitType, @JsonProperty(value="max_appointments_per_day_limit") Integer maxAppointmentsPerDayLimit, @JsonProperty(value="cancellation_window_seconds") Integer cancellationWindowSeconds, @JsonProperty(value="cancellation_fee_money") Money cancellationFeeMoney, @JsonProperty(value="cancellation_policy") String cancellationPolicy, @JsonProperty(value="cancellation_policy_text") String cancellationPolicyText, @JsonProperty(value="skip_booking_flow_staff_selection") Boolean skipBookingFlowStaffSelection) {
        this.locationTypes = locationTypes;
        this.alignmentTime = alignmentTime;
        this.minBookingLeadTimeSeconds = minBookingLeadTimeSeconds;
        this.maxBookingLeadTimeSeconds = maxBookingLeadTimeSeconds;
        this.anyTeamMemberBookingEnabled = anyTeamMemberBookingEnabled;
        this.multipleServiceBookingEnabled = multipleServiceBookingEnabled;
        this.maxAppointmentsPerDayLimitType = maxAppointmentsPerDayLimitType;
        this.maxAppointmentsPerDayLimit = maxAppointmentsPerDayLimit;
        this.cancellationWindowSeconds = cancellationWindowSeconds;
        this.cancellationFeeMoney = cancellationFeeMoney;
        this.cancellationPolicy = cancellationPolicy;
        this.cancellationPolicyText = cancellationPolicyText;
        this.skipBookingFlowStaffSelection = skipBookingFlowStaffSelection;
    }

    @JsonGetter(value="location_types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getLocationTypes() {
        return this.locationTypes;
    }

    @JsonGetter(value="alignment_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAlignmentTime() {
        return this.alignmentTime;
    }

    @JsonGetter(value="min_booking_lead_time_seconds")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMinBookingLeadTimeSeconds() {
        return this.minBookingLeadTimeSeconds;
    }

    @JsonGetter(value="max_booking_lead_time_seconds")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxBookingLeadTimeSeconds() {
        return this.maxBookingLeadTimeSeconds;
    }

    @JsonGetter(value="any_team_member_booking_enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAnyTeamMemberBookingEnabled() {
        return this.anyTeamMemberBookingEnabled;
    }

    @JsonGetter(value="multiple_service_booking_enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getMultipleServiceBookingEnabled() {
        return this.multipleServiceBookingEnabled;
    }

    @JsonGetter(value="max_appointments_per_day_limit_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMaxAppointmentsPerDayLimitType() {
        return this.maxAppointmentsPerDayLimitType;
    }

    @JsonGetter(value="max_appointments_per_day_limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxAppointmentsPerDayLimit() {
        return this.maxAppointmentsPerDayLimit;
    }

    @JsonGetter(value="cancellation_window_seconds")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getCancellationWindowSeconds() {
        return this.cancellationWindowSeconds;
    }

    @JsonGetter(value="cancellation_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getCancellationFeeMoney() {
        return this.cancellationFeeMoney;
    }

    @JsonGetter(value="cancellation_policy")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCancellationPolicy() {
        return this.cancellationPolicy;
    }

    @JsonGetter(value="cancellation_policy_text")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCancellationPolicyText() {
        return this.cancellationPolicyText;
    }

    @JsonGetter(value="skip_booking_flow_staff_selection")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getSkipBookingFlowStaffSelection() {
        return this.skipBookingFlowStaffSelection;
    }

    public int hashCode() {
        return Objects.hash(this.locationTypes, this.alignmentTime, this.minBookingLeadTimeSeconds, this.maxBookingLeadTimeSeconds, this.anyTeamMemberBookingEnabled, this.multipleServiceBookingEnabled, this.maxAppointmentsPerDayLimitType, this.maxAppointmentsPerDayLimit, this.cancellationWindowSeconds, this.cancellationFeeMoney, this.cancellationPolicy, this.cancellationPolicyText, this.skipBookingFlowStaffSelection);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BusinessAppointmentSettings)) {
            return false;
        }
        BusinessAppointmentSettings other = (BusinessAppointmentSettings)obj;
        return Objects.equals(this.locationTypes, other.locationTypes) && Objects.equals(this.alignmentTime, other.alignmentTime) && Objects.equals(this.minBookingLeadTimeSeconds, other.minBookingLeadTimeSeconds) && Objects.equals(this.maxBookingLeadTimeSeconds, other.maxBookingLeadTimeSeconds) && Objects.equals(this.anyTeamMemberBookingEnabled, other.anyTeamMemberBookingEnabled) && Objects.equals(this.multipleServiceBookingEnabled, other.multipleServiceBookingEnabled) && Objects.equals(this.maxAppointmentsPerDayLimitType, other.maxAppointmentsPerDayLimitType) && Objects.equals(this.maxAppointmentsPerDayLimit, other.maxAppointmentsPerDayLimit) && Objects.equals(this.cancellationWindowSeconds, other.cancellationWindowSeconds) && Objects.equals(this.cancellationFeeMoney, other.cancellationFeeMoney) && Objects.equals(this.cancellationPolicy, other.cancellationPolicy) && Objects.equals(this.cancellationPolicyText, other.cancellationPolicyText) && Objects.equals(this.skipBookingFlowStaffSelection, other.skipBookingFlowStaffSelection);
    }

    public String toString() {
        return "BusinessAppointmentSettings [locationTypes=" + this.locationTypes + ", alignmentTime=" + this.alignmentTime + ", minBookingLeadTimeSeconds=" + this.minBookingLeadTimeSeconds + ", maxBookingLeadTimeSeconds=" + this.maxBookingLeadTimeSeconds + ", anyTeamMemberBookingEnabled=" + this.anyTeamMemberBookingEnabled + ", multipleServiceBookingEnabled=" + this.multipleServiceBookingEnabled + ", maxAppointmentsPerDayLimitType=" + this.maxAppointmentsPerDayLimitType + ", maxAppointmentsPerDayLimit=" + this.maxAppointmentsPerDayLimit + ", cancellationWindowSeconds=" + this.cancellationWindowSeconds + ", cancellationFeeMoney=" + this.cancellationFeeMoney + ", cancellationPolicy=" + this.cancellationPolicy + ", cancellationPolicyText=" + this.cancellationPolicyText + ", skipBookingFlowStaffSelection=" + this.skipBookingFlowStaffSelection + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().locationTypes(this.getLocationTypes()).alignmentTime(this.getAlignmentTime()).minBookingLeadTimeSeconds(this.getMinBookingLeadTimeSeconds()).maxBookingLeadTimeSeconds(this.getMaxBookingLeadTimeSeconds()).anyTeamMemberBookingEnabled(this.getAnyTeamMemberBookingEnabled()).multipleServiceBookingEnabled(this.getMultipleServiceBookingEnabled()).maxAppointmentsPerDayLimitType(this.getMaxAppointmentsPerDayLimitType()).maxAppointmentsPerDayLimit(this.getMaxAppointmentsPerDayLimit()).cancellationWindowSeconds(this.getCancellationWindowSeconds()).cancellationFeeMoney(this.getCancellationFeeMoney()).cancellationPolicy(this.getCancellationPolicy()).cancellationPolicyText(this.getCancellationPolicyText()).skipBookingFlowStaffSelection(this.getSkipBookingFlowStaffSelection());
        return builder;
    }

    public static class Builder {
        private List<String> locationTypes;
        private String alignmentTime;
        private Integer minBookingLeadTimeSeconds;
        private Integer maxBookingLeadTimeSeconds;
        private Boolean anyTeamMemberBookingEnabled;
        private Boolean multipleServiceBookingEnabled;
        private String maxAppointmentsPerDayLimitType;
        private Integer maxAppointmentsPerDayLimit;
        private Integer cancellationWindowSeconds;
        private Money cancellationFeeMoney;
        private String cancellationPolicy;
        private String cancellationPolicyText;
        private Boolean skipBookingFlowStaffSelection;

        public Builder locationTypes(List<String> locationTypes) {
            this.locationTypes = locationTypes;
            return this;
        }

        public Builder alignmentTime(String alignmentTime) {
            this.alignmentTime = alignmentTime;
            return this;
        }

        public Builder minBookingLeadTimeSeconds(Integer minBookingLeadTimeSeconds) {
            this.minBookingLeadTimeSeconds = minBookingLeadTimeSeconds;
            return this;
        }

        public Builder maxBookingLeadTimeSeconds(Integer maxBookingLeadTimeSeconds) {
            this.maxBookingLeadTimeSeconds = maxBookingLeadTimeSeconds;
            return this;
        }

        public Builder anyTeamMemberBookingEnabled(Boolean anyTeamMemberBookingEnabled) {
            this.anyTeamMemberBookingEnabled = anyTeamMemberBookingEnabled;
            return this;
        }

        public Builder multipleServiceBookingEnabled(Boolean multipleServiceBookingEnabled) {
            this.multipleServiceBookingEnabled = multipleServiceBookingEnabled;
            return this;
        }

        public Builder maxAppointmentsPerDayLimitType(String maxAppointmentsPerDayLimitType) {
            this.maxAppointmentsPerDayLimitType = maxAppointmentsPerDayLimitType;
            return this;
        }

        public Builder maxAppointmentsPerDayLimit(Integer maxAppointmentsPerDayLimit) {
            this.maxAppointmentsPerDayLimit = maxAppointmentsPerDayLimit;
            return this;
        }

        public Builder cancellationWindowSeconds(Integer cancellationWindowSeconds) {
            this.cancellationWindowSeconds = cancellationWindowSeconds;
            return this;
        }

        public Builder cancellationFeeMoney(Money cancellationFeeMoney) {
            this.cancellationFeeMoney = cancellationFeeMoney;
            return this;
        }

        public Builder cancellationPolicy(String cancellationPolicy) {
            this.cancellationPolicy = cancellationPolicy;
            return this;
        }

        public Builder cancellationPolicyText(String cancellationPolicyText) {
            this.cancellationPolicyText = cancellationPolicyText;
            return this;
        }

        public Builder skipBookingFlowStaffSelection(Boolean skipBookingFlowStaffSelection) {
            this.skipBookingFlowStaffSelection = skipBookingFlowStaffSelection;
            return this;
        }

        public BusinessAppointmentSettings build() {
            return new BusinessAppointmentSettings(this.locationTypes, this.alignmentTime, this.minBookingLeadTimeSeconds, this.maxBookingLeadTimeSeconds, this.anyTeamMemberBookingEnabled, this.multipleServiceBookingEnabled, this.maxAppointmentsPerDayLimitType, this.maxAppointmentsPerDayLimit, this.cancellationWindowSeconds, this.cancellationFeeMoney, this.cancellationPolicy, this.cancellationPolicyText, this.skipBookingFlowStaffSelection);
        }
    }
}

