/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.BusinessAppointmentSettings;
import java.util.Objects;

public class BusinessBookingProfile {
    private final String sellerId;
    private final String createdAt;
    private final Boolean bookingEnabled;
    private final String customerTimezoneChoice;
    private final String bookingPolicy;
    private final Boolean allowUserCancel;
    private final BusinessAppointmentSettings businessAppointmentSettings;
    private final Boolean supportSellerLevelWrites;

    @JsonCreator
    public BusinessBookingProfile(@JsonProperty(value="seller_id") String sellerId, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="booking_enabled") Boolean bookingEnabled, @JsonProperty(value="customer_timezone_choice") String customerTimezoneChoice, @JsonProperty(value="booking_policy") String bookingPolicy, @JsonProperty(value="allow_user_cancel") Boolean allowUserCancel, @JsonProperty(value="business_appointment_settings") BusinessAppointmentSettings businessAppointmentSettings, @JsonProperty(value="support_seller_level_writes") Boolean supportSellerLevelWrites) {
        this.sellerId = sellerId;
        this.createdAt = createdAt;
        this.bookingEnabled = bookingEnabled;
        this.customerTimezoneChoice = customerTimezoneChoice;
        this.bookingPolicy = bookingPolicy;
        this.allowUserCancel = allowUserCancel;
        this.businessAppointmentSettings = businessAppointmentSettings;
        this.supportSellerLevelWrites = supportSellerLevelWrites;
    }

    @JsonGetter(value="seller_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSellerId() {
        return this.sellerId;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="booking_enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getBookingEnabled() {
        return this.bookingEnabled;
    }

    @JsonGetter(value="customer_timezone_choice")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerTimezoneChoice() {
        return this.customerTimezoneChoice;
    }

    @JsonGetter(value="booking_policy")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBookingPolicy() {
        return this.bookingPolicy;
    }

    @JsonGetter(value="allow_user_cancel")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAllowUserCancel() {
        return this.allowUserCancel;
    }

    @JsonGetter(value="business_appointment_settings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BusinessAppointmentSettings getBusinessAppointmentSettings() {
        return this.businessAppointmentSettings;
    }

    @JsonGetter(value="support_seller_level_writes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getSupportSellerLevelWrites() {
        return this.supportSellerLevelWrites;
    }

    public int hashCode() {
        return Objects.hash(this.sellerId, this.createdAt, this.bookingEnabled, this.customerTimezoneChoice, this.bookingPolicy, this.allowUserCancel, this.businessAppointmentSettings, this.supportSellerLevelWrites);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BusinessBookingProfile)) {
            return false;
        }
        BusinessBookingProfile other = (BusinessBookingProfile)obj;
        return Objects.equals(this.sellerId, other.sellerId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.bookingEnabled, other.bookingEnabled) && Objects.equals(this.customerTimezoneChoice, other.customerTimezoneChoice) && Objects.equals(this.bookingPolicy, other.bookingPolicy) && Objects.equals(this.allowUserCancel, other.allowUserCancel) && Objects.equals(this.businessAppointmentSettings, other.businessAppointmentSettings) && Objects.equals(this.supportSellerLevelWrites, other.supportSellerLevelWrites);
    }

    public String toString() {
        return "BusinessBookingProfile [sellerId=" + this.sellerId + ", createdAt=" + this.createdAt + ", bookingEnabled=" + this.bookingEnabled + ", customerTimezoneChoice=" + this.customerTimezoneChoice + ", bookingPolicy=" + this.bookingPolicy + ", allowUserCancel=" + this.allowUserCancel + ", businessAppointmentSettings=" + this.businessAppointmentSettings + ", supportSellerLevelWrites=" + this.supportSellerLevelWrites + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().sellerId(this.getSellerId()).createdAt(this.getCreatedAt()).bookingEnabled(this.getBookingEnabled()).customerTimezoneChoice(this.getCustomerTimezoneChoice()).bookingPolicy(this.getBookingPolicy()).allowUserCancel(this.getAllowUserCancel()).businessAppointmentSettings(this.getBusinessAppointmentSettings()).supportSellerLevelWrites(this.getSupportSellerLevelWrites());
        return builder;
    }

    public static class Builder {
        private String sellerId;
        private String createdAt;
        private Boolean bookingEnabled;
        private String customerTimezoneChoice;
        private String bookingPolicy;
        private Boolean allowUserCancel;
        private BusinessAppointmentSettings businessAppointmentSettings;
        private Boolean supportSellerLevelWrites;

        public Builder sellerId(String sellerId) {
            this.sellerId = sellerId;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder bookingEnabled(Boolean bookingEnabled) {
            this.bookingEnabled = bookingEnabled;
            return this;
        }

        public Builder customerTimezoneChoice(String customerTimezoneChoice) {
            this.customerTimezoneChoice = customerTimezoneChoice;
            return this;
        }

        public Builder bookingPolicy(String bookingPolicy) {
            this.bookingPolicy = bookingPolicy;
            return this;
        }

        public Builder allowUserCancel(Boolean allowUserCancel) {
            this.allowUserCancel = allowUserCancel;
            return this;
        }

        public Builder businessAppointmentSettings(BusinessAppointmentSettings businessAppointmentSettings) {
            this.businessAppointmentSettings = businessAppointmentSettings;
            return this;
        }

        public Builder supportSellerLevelWrites(Boolean supportSellerLevelWrites) {
            this.supportSellerLevelWrites = supportSellerLevelWrites;
            return this;
        }

        public BusinessBookingProfile build() {
            return new BusinessBookingProfile(this.sellerId, this.createdAt, this.bookingEnabled, this.customerTimezoneChoice, this.bookingPolicy, this.allowUserCancel, this.businessAppointmentSettings, this.supportSellerLevelWrites);
        }
    }
}

