/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class BusinessHoursPeriod {
    private final String dayOfWeek;
    private final String startLocalTime;
    private final String endLocalTime;

    @JsonCreator
    public BusinessHoursPeriod(@JsonProperty(value="day_of_week") String dayOfWeek, @JsonProperty(value="start_local_time") String startLocalTime, @JsonProperty(value="end_local_time") String endLocalTime) {
        this.dayOfWeek = dayOfWeek;
        this.startLocalTime = startLocalTime;
        this.endLocalTime = endLocalTime;
    }

    @JsonGetter(value="day_of_week")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    @JsonGetter(value="start_local_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStartLocalTime() {
        return this.startLocalTime;
    }

    @JsonGetter(value="end_local_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndLocalTime() {
        return this.endLocalTime;
    }

    public int hashCode() {
        return Objects.hash(this.dayOfWeek, this.startLocalTime, this.endLocalTime);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BusinessHoursPeriod)) {
            return false;
        }
        BusinessHoursPeriod other = (BusinessHoursPeriod)obj;
        return Objects.equals(this.dayOfWeek, other.dayOfWeek) && Objects.equals(this.startLocalTime, other.startLocalTime) && Objects.equals(this.endLocalTime, other.endLocalTime);
    }

    public String toString() {
        return "BusinessHoursPeriod [dayOfWeek=" + this.dayOfWeek + ", startLocalTime=" + this.startLocalTime + ", endLocalTime=" + this.endLocalTime + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().dayOfWeek(this.getDayOfWeek()).startLocalTime(this.getStartLocalTime()).endLocalTime(this.getEndLocalTime());
        return builder;
    }

    public static class Builder {
        private String dayOfWeek;
        private String startLocalTime;
        private String endLocalTime;

        public Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public Builder startLocalTime(String startLocalTime) {
            this.startLocalTime = startLocalTime;
            return this;
        }

        public Builder endLocalTime(String endLocalTime) {
            this.endLocalTime = endLocalTime;
            return this;
        }

        public BusinessHoursPeriod build() {
            return new BusinessHoursPeriod(this.dayOfWeek, this.startLocalTime, this.endLocalTime);
        }
    }
}

