/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.AfterpayDetails;
import java.util.Objects;

public class BuyNowPayLaterDetails {
    private final String brand;
    private final AfterpayDetails afterpayDetails;

    @JsonCreator
    public BuyNowPayLaterDetails(@JsonProperty(value="brand") String brand, @JsonProperty(value="afterpay_details") AfterpayDetails afterpayDetails) {
        this.brand = brand;
        this.afterpayDetails = afterpayDetails;
    }

    @JsonGetter(value="brand")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBrand() {
        return this.brand;
    }

    @JsonGetter(value="afterpay_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AfterpayDetails getAfterpayDetails() {
        return this.afterpayDetails;
    }

    public int hashCode() {
        return Objects.hash(this.brand, this.afterpayDetails);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BuyNowPayLaterDetails)) {
            return false;
        }
        BuyNowPayLaterDetails other = (BuyNowPayLaterDetails)obj;
        return Objects.equals(this.brand, other.brand) && Objects.equals(this.afterpayDetails, other.afterpayDetails);
    }

    public String toString() {
        return "BuyNowPayLaterDetails [brand=" + this.brand + ", afterpayDetails=" + this.afterpayDetails + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().brand(this.getBrand()).afterpayDetails(this.getAfterpayDetails());
        return builder;
    }

    public static class Builder {
        private String brand;
        private AfterpayDetails afterpayDetails;

        public Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public Builder afterpayDetails(AfterpayDetails afterpayDetails) {
            this.afterpayDetails = afterpayDetails;
            return this;
        }

        public BuyNowPayLaterDetails build() {
            return new BuyNowPayLaterDetails(this.brand, this.afterpayDetails);
        }
    }
}

