/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class CalculateLoyaltyPointsRequest {
    private final String orderId;
    private final Money transactionAmountMoney;

    @JsonCreator
    public CalculateLoyaltyPointsRequest(@JsonProperty(value="order_id") String orderId, @JsonProperty(value="transaction_amount_money") Money transactionAmountMoney) {
        this.orderId = orderId;
        this.transactionAmountMoney = transactionAmountMoney;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="transaction_amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTransactionAmountMoney() {
        return this.transactionAmountMoney;
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.transactionAmountMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CalculateLoyaltyPointsRequest)) {
            return false;
        }
        CalculateLoyaltyPointsRequest other = (CalculateLoyaltyPointsRequest)obj;
        return Objects.equals(this.orderId, other.orderId) && Objects.equals(this.transactionAmountMoney, other.transactionAmountMoney);
    }

    public String toString() {
        return "CalculateLoyaltyPointsRequest [orderId=" + this.orderId + ", transactionAmountMoney=" + this.transactionAmountMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().orderId(this.getOrderId()).transactionAmountMoney(this.getTransactionAmountMoney());
        return builder;
    }

    public static class Builder {
        private String orderId;
        private Money transactionAmountMoney;

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder transactionAmountMoney(Money transactionAmountMoney) {
            this.transactionAmountMoney = transactionAmountMoney;
            return this;
        }

        public CalculateLoyaltyPointsRequest build() {
            return new CalculateLoyaltyPointsRequest(this.orderId, this.transactionAmountMoney);
        }
    }
}

