/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Order;
import com.squareup.square.models.OrderReward;
import java.util.List;
import java.util.Objects;

public class CalculateOrderRequest {
    private final Order order;
    private final List<OrderReward> proposedRewards;

    @JsonCreator
    public CalculateOrderRequest(@JsonProperty(value="order") Order order, @JsonProperty(value="proposed_rewards") List<OrderReward> proposedRewards) {
        this.order = order;
        this.proposedRewards = proposedRewards;
    }

    @JsonGetter(value="order")
    public Order getOrder() {
        return this.order;
    }

    @JsonGetter(value="proposed_rewards")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderReward> getProposedRewards() {
        return this.proposedRewards;
    }

    public int hashCode() {
        return Objects.hash(this.order, this.proposedRewards);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CalculateOrderRequest)) {
            return false;
        }
        CalculateOrderRequest other = (CalculateOrderRequest)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.proposedRewards, other.proposedRewards);
    }

    public String toString() {
        return "CalculateOrderRequest [order=" + this.order + ", proposedRewards=" + this.proposedRewards + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.order).proposedRewards(this.getProposedRewards());
        return builder;
    }

    public static class Builder {
        private Order order;
        private List<OrderReward> proposedRewards;

        public Builder(Order order) {
            this.order = order;
        }

        public Builder order(Order order) {
            this.order = order;
            return this;
        }

        public Builder proposedRewards(List<OrderReward> proposedRewards) {
            this.proposedRewards = proposedRewards;
            return this;
        }

        public CalculateOrderRequest build() {
            return new CalculateOrderRequest(this.order, this.proposedRewards);
        }
    }
}

