/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CancelBookingRequest {
    private final String idempotencyKey;
    private final Integer bookingVersion;

    @JsonCreator
    public CancelBookingRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="booking_version") Integer bookingVersion) {
        this.idempotencyKey = idempotencyKey;
        this.bookingVersion = bookingVersion;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="booking_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getBookingVersion() {
        return this.bookingVersion;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.bookingVersion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CancelBookingRequest)) {
            return false;
        }
        CancelBookingRequest other = (CancelBookingRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.bookingVersion, other.bookingVersion);
    }

    public String toString() {
        return "CancelBookingRequest [idempotencyKey=" + this.idempotencyKey + ", bookingVersion=" + this.bookingVersion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().idempotencyKey(this.getIdempotencyKey()).bookingVersion(this.getBookingVersion());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private Integer bookingVersion;

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder bookingVersion(Integer bookingVersion) {
            this.bookingVersion = bookingVersion;
            return this;
        }

        public CancelBookingRequest build() {
            return new CancelBookingRequest(this.idempotencyKey, this.bookingVersion);
        }
    }
}

