/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Address;
import java.util.Objects;

public class Card {
    private final String id;
    private final String cardBrand;
    private final String last4;
    private final Long expMonth;
    private final Long expYear;
    private final String cardholderName;
    private final Address billingAddress;
    private final String fingerprint;
    private final String customerId;
    private final String merchantId;
    private final String referenceId;
    private final Boolean enabled;
    private final String cardType;
    private final String prepaidType;
    private final String bin;
    private final Long version;

    @JsonCreator
    public Card(@JsonProperty(value="id") String id, @JsonProperty(value="card_brand") String cardBrand, @JsonProperty(value="last_4") String last4, @JsonProperty(value="exp_month") Long expMonth, @JsonProperty(value="exp_year") Long expYear, @JsonProperty(value="cardholder_name") String cardholderName, @JsonProperty(value="billing_address") Address billingAddress, @JsonProperty(value="fingerprint") String fingerprint, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="card_type") String cardType, @JsonProperty(value="prepaid_type") String prepaidType, @JsonProperty(value="bin") String bin, @JsonProperty(value="version") Long version) {
        this.id = id;
        this.cardBrand = cardBrand;
        this.last4 = last4;
        this.expMonth = expMonth;
        this.expYear = expYear;
        this.cardholderName = cardholderName;
        this.billingAddress = billingAddress;
        this.fingerprint = fingerprint;
        this.customerId = customerId;
        this.merchantId = merchantId;
        this.referenceId = referenceId;
        this.enabled = enabled;
        this.cardType = cardType;
        this.prepaidType = prepaidType;
        this.bin = bin;
        this.version = version;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="card_brand")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardBrand() {
        return this.cardBrand;
    }

    @JsonGetter(value="last_4")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLast4() {
        return this.last4;
    }

    @JsonGetter(value="exp_month")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getExpMonth() {
        return this.expMonth;
    }

    @JsonGetter(value="exp_year")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getExpYear() {
        return this.expYear;
    }

    @JsonGetter(value="cardholder_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardholderName() {
        return this.cardholderName;
    }

    @JsonGetter(value="billing_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonGetter(value="fingerprint")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFingerprint() {
        return this.fingerprint;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonGetter(value="card_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardType() {
        return this.cardType;
    }

    @JsonGetter(value="prepaid_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrepaidType() {
        return this.prepaidType;
    }

    @JsonGetter(value="bin")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBin() {
        return this.bin;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.cardBrand, this.last4, this.expMonth, this.expYear, this.cardholderName, this.billingAddress, this.fingerprint, this.customerId, this.merchantId, this.referenceId, this.enabled, this.cardType, this.prepaidType, this.bin, this.version);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Card)) {
            return false;
        }
        Card other = (Card)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.cardBrand, other.cardBrand) && Objects.equals(this.last4, other.last4) && Objects.equals(this.expMonth, other.expMonth) && Objects.equals(this.expYear, other.expYear) && Objects.equals(this.cardholderName, other.cardholderName) && Objects.equals(this.billingAddress, other.billingAddress) && Objects.equals(this.fingerprint, other.fingerprint) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.cardType, other.cardType) && Objects.equals(this.prepaidType, other.prepaidType) && Objects.equals(this.bin, other.bin) && Objects.equals(this.version, other.version);
    }

    public String toString() {
        return "Card [id=" + this.id + ", cardBrand=" + this.cardBrand + ", last4=" + this.last4 + ", expMonth=" + this.expMonth + ", expYear=" + this.expYear + ", cardholderName=" + this.cardholderName + ", billingAddress=" + this.billingAddress + ", fingerprint=" + this.fingerprint + ", customerId=" + this.customerId + ", merchantId=" + this.merchantId + ", referenceId=" + this.referenceId + ", enabled=" + this.enabled + ", cardType=" + this.cardType + ", prepaidType=" + this.prepaidType + ", bin=" + this.bin + ", version=" + this.version + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).cardBrand(this.getCardBrand()).last4(this.getLast4()).expMonth(this.getExpMonth()).expYear(this.getExpYear()).cardholderName(this.getCardholderName()).billingAddress(this.getBillingAddress()).fingerprint(this.getFingerprint()).customerId(this.getCustomerId()).merchantId(this.getMerchantId()).referenceId(this.getReferenceId()).enabled(this.getEnabled()).cardType(this.getCardType()).prepaidType(this.getPrepaidType()).bin(this.getBin()).version(this.getVersion());
        return builder;
    }

    public static class Builder {
        private String id;
        private String cardBrand;
        private String last4;
        private Long expMonth;
        private Long expYear;
        private String cardholderName;
        private Address billingAddress;
        private String fingerprint;
        private String customerId;
        private String merchantId;
        private String referenceId;
        private Boolean enabled;
        private String cardType;
        private String prepaidType;
        private String bin;
        private Long version;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder cardBrand(String cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        public Builder last4(String last4) {
            this.last4 = last4;
            return this;
        }

        public Builder expMonth(Long expMonth) {
            this.expMonth = expMonth;
            return this;
        }

        public Builder expYear(Long expYear) {
            this.expYear = expYear;
            return this;
        }

        public Builder cardholderName(String cardholderName) {
            this.cardholderName = cardholderName;
            return this;
        }

        public Builder billingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder cardType(String cardType) {
            this.cardType = cardType;
            return this;
        }

        public Builder prepaidType(String prepaidType) {
            this.prepaidType = prepaidType;
            return this;
        }

        public Builder bin(String bin) {
            this.bin = bin;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Card build() {
            return new Card(this.id, this.cardBrand, this.last4, this.expMonth, this.expYear, this.cardholderName, this.billingAddress, this.fingerprint, this.customerId, this.merchantId, this.referenceId, this.enabled, this.cardType, this.prepaidType, this.bin, this.version);
        }
    }
}

