/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Card;
import com.squareup.square.models.CardPaymentTimeline;
import com.squareup.square.models.DeviceDetails;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class CardPaymentDetails {
    private final String status;
    private final Card card;
    private final String entryMethod;
    private final String cvvStatus;
    private final String avsStatus;
    private final String authResultCode;
    private final String applicationIdentifier;
    private final String applicationName;
    private final String applicationCryptogram;
    private final String verificationMethod;
    private final String verificationResults;
    private final String statementDescription;
    private final DeviceDetails deviceDetails;
    private final CardPaymentTimeline cardPaymentTimeline;
    private final Boolean refundRequiresCardPresence;
    private final List<Error> errors;

    @JsonCreator
    public CardPaymentDetails(@JsonProperty(value="status") String status, @JsonProperty(value="card") Card card, @JsonProperty(value="entry_method") String entryMethod, @JsonProperty(value="cvv_status") String cvvStatus, @JsonProperty(value="avs_status") String avsStatus, @JsonProperty(value="auth_result_code") String authResultCode, @JsonProperty(value="application_identifier") String applicationIdentifier, @JsonProperty(value="application_name") String applicationName, @JsonProperty(value="application_cryptogram") String applicationCryptogram, @JsonProperty(value="verification_method") String verificationMethod, @JsonProperty(value="verification_results") String verificationResults, @JsonProperty(value="statement_description") String statementDescription, @JsonProperty(value="device_details") DeviceDetails deviceDetails, @JsonProperty(value="card_payment_timeline") CardPaymentTimeline cardPaymentTimeline, @JsonProperty(value="refund_requires_card_presence") Boolean refundRequiresCardPresence, @JsonProperty(value="errors") List<Error> errors) {
        this.status = status;
        this.card = card;
        this.entryMethod = entryMethod;
        this.cvvStatus = cvvStatus;
        this.avsStatus = avsStatus;
        this.authResultCode = authResultCode;
        this.applicationIdentifier = applicationIdentifier;
        this.applicationName = applicationName;
        this.applicationCryptogram = applicationCryptogram;
        this.verificationMethod = verificationMethod;
        this.verificationResults = verificationResults;
        this.statementDescription = statementDescription;
        this.deviceDetails = deviceDetails;
        this.cardPaymentTimeline = cardPaymentTimeline;
        this.refundRequiresCardPresence = refundRequiresCardPresence;
        this.errors = errors;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Card getCard() {
        return this.card;
    }

    @JsonGetter(value="entry_method")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEntryMethod() {
        return this.entryMethod;
    }

    @JsonGetter(value="cvv_status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCvvStatus() {
        return this.cvvStatus;
    }

    @JsonGetter(value="avs_status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAvsStatus() {
        return this.avsStatus;
    }

    @JsonGetter(value="auth_result_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAuthResultCode() {
        return this.authResultCode;
    }

    @JsonGetter(value="application_identifier")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    @JsonGetter(value="application_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getApplicationName() {
        return this.applicationName;
    }

    @JsonGetter(value="application_cryptogram")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getApplicationCryptogram() {
        return this.applicationCryptogram;
    }

    @JsonGetter(value="verification_method")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVerificationMethod() {
        return this.verificationMethod;
    }

    @JsonGetter(value="verification_results")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVerificationResults() {
        return this.verificationResults;
    }

    @JsonGetter(value="statement_description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @JsonGetter(value="device_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DeviceDetails getDeviceDetails() {
        return this.deviceDetails;
    }

    @JsonGetter(value="card_payment_timeline")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CardPaymentTimeline getCardPaymentTimeline() {
        return this.cardPaymentTimeline;
    }

    @JsonGetter(value="refund_requires_card_presence")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getRefundRequiresCardPresence() {
        return this.refundRequiresCardPresence;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.status, this.card, this.entryMethod, this.cvvStatus, this.avsStatus, this.authResultCode, this.applicationIdentifier, this.applicationName, this.applicationCryptogram, this.verificationMethod, this.verificationResults, this.statementDescription, this.deviceDetails, this.cardPaymentTimeline, this.refundRequiresCardPresence, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CardPaymentDetails)) {
            return false;
        }
        CardPaymentDetails other = (CardPaymentDetails)obj;
        return Objects.equals(this.status, other.status) && Objects.equals(this.card, other.card) && Objects.equals(this.entryMethod, other.entryMethod) && Objects.equals(this.cvvStatus, other.cvvStatus) && Objects.equals(this.avsStatus, other.avsStatus) && Objects.equals(this.authResultCode, other.authResultCode) && Objects.equals(this.applicationIdentifier, other.applicationIdentifier) && Objects.equals(this.applicationName, other.applicationName) && Objects.equals(this.applicationCryptogram, other.applicationCryptogram) && Objects.equals(this.verificationMethod, other.verificationMethod) && Objects.equals(this.verificationResults, other.verificationResults) && Objects.equals(this.statementDescription, other.statementDescription) && Objects.equals(this.deviceDetails, other.deviceDetails) && Objects.equals(this.cardPaymentTimeline, other.cardPaymentTimeline) && Objects.equals(this.refundRequiresCardPresence, other.refundRequiresCardPresence) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "CardPaymentDetails [status=" + this.status + ", card=" + this.card + ", entryMethod=" + this.entryMethod + ", cvvStatus=" + this.cvvStatus + ", avsStatus=" + this.avsStatus + ", authResultCode=" + this.authResultCode + ", applicationIdentifier=" + this.applicationIdentifier + ", applicationName=" + this.applicationName + ", applicationCryptogram=" + this.applicationCryptogram + ", verificationMethod=" + this.verificationMethod + ", verificationResults=" + this.verificationResults + ", statementDescription=" + this.statementDescription + ", deviceDetails=" + this.deviceDetails + ", cardPaymentTimeline=" + this.cardPaymentTimeline + ", refundRequiresCardPresence=" + this.refundRequiresCardPresence + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().status(this.getStatus()).card(this.getCard()).entryMethod(this.getEntryMethod()).cvvStatus(this.getCvvStatus()).avsStatus(this.getAvsStatus()).authResultCode(this.getAuthResultCode()).applicationIdentifier(this.getApplicationIdentifier()).applicationName(this.getApplicationName()).applicationCryptogram(this.getApplicationCryptogram()).verificationMethod(this.getVerificationMethod()).verificationResults(this.getVerificationResults()).statementDescription(this.getStatementDescription()).deviceDetails(this.getDeviceDetails()).cardPaymentTimeline(this.getCardPaymentTimeline()).refundRequiresCardPresence(this.getRefundRequiresCardPresence()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private String status;
        private Card card;
        private String entryMethod;
        private String cvvStatus;
        private String avsStatus;
        private String authResultCode;
        private String applicationIdentifier;
        private String applicationName;
        private String applicationCryptogram;
        private String verificationMethod;
        private String verificationResults;
        private String statementDescription;
        private DeviceDetails deviceDetails;
        private CardPaymentTimeline cardPaymentTimeline;
        private Boolean refundRequiresCardPresence;
        private List<Error> errors;

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder card(Card card) {
            this.card = card;
            return this;
        }

        public Builder entryMethod(String entryMethod) {
            this.entryMethod = entryMethod;
            return this;
        }

        public Builder cvvStatus(String cvvStatus) {
            this.cvvStatus = cvvStatus;
            return this;
        }

        public Builder avsStatus(String avsStatus) {
            this.avsStatus = avsStatus;
            return this;
        }

        public Builder authResultCode(String authResultCode) {
            this.authResultCode = authResultCode;
            return this;
        }

        public Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder applicationCryptogram(String applicationCryptogram) {
            this.applicationCryptogram = applicationCryptogram;
            return this;
        }

        public Builder verificationMethod(String verificationMethod) {
            this.verificationMethod = verificationMethod;
            return this;
        }

        public Builder verificationResults(String verificationResults) {
            this.verificationResults = verificationResults;
            return this;
        }

        public Builder statementDescription(String statementDescription) {
            this.statementDescription = statementDescription;
            return this;
        }

        public Builder deviceDetails(DeviceDetails deviceDetails) {
            this.deviceDetails = deviceDetails;
            return this;
        }

        public Builder cardPaymentTimeline(CardPaymentTimeline cardPaymentTimeline) {
            this.cardPaymentTimeline = cardPaymentTimeline;
            return this;
        }

        public Builder refundRequiresCardPresence(Boolean refundRequiresCardPresence) {
            this.refundRequiresCardPresence = refundRequiresCardPresence;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public CardPaymentDetails build() {
            return new CardPaymentDetails(this.status, this.card, this.entryMethod, this.cvvStatus, this.avsStatus, this.authResultCode, this.applicationIdentifier, this.applicationName, this.applicationCryptogram, this.verificationMethod, this.verificationResults, this.statementDescription, this.deviceDetails, this.cardPaymentTimeline, this.refundRequiresCardPresence, this.errors);
        }
    }
}

