/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CardPaymentTimeline {
    private final String authorizedAt;
    private final String capturedAt;
    private final String voidedAt;

    @JsonCreator
    public CardPaymentTimeline(@JsonProperty(value="authorized_at") String authorizedAt, @JsonProperty(value="captured_at") String capturedAt, @JsonProperty(value="voided_at") String voidedAt) {
        this.authorizedAt = authorizedAt;
        this.capturedAt = capturedAt;
        this.voidedAt = voidedAt;
    }

    @JsonGetter(value="authorized_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAuthorizedAt() {
        return this.authorizedAt;
    }

    @JsonGetter(value="captured_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCapturedAt() {
        return this.capturedAt;
    }

    @JsonGetter(value="voided_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVoidedAt() {
        return this.voidedAt;
    }

    public int hashCode() {
        return Objects.hash(this.authorizedAt, this.capturedAt, this.voidedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CardPaymentTimeline)) {
            return false;
        }
        CardPaymentTimeline other = (CardPaymentTimeline)obj;
        return Objects.equals(this.authorizedAt, other.authorizedAt) && Objects.equals(this.capturedAt, other.capturedAt) && Objects.equals(this.voidedAt, other.voidedAt);
    }

    public String toString() {
        return "CardPaymentTimeline [authorizedAt=" + this.authorizedAt + ", capturedAt=" + this.capturedAt + ", voidedAt=" + this.voidedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().authorizedAt(this.getAuthorizedAt()).capturedAt(this.getCapturedAt()).voidedAt(this.getVoidedAt());
        return builder;
    }

    public static class Builder {
        private String authorizedAt;
        private String capturedAt;
        private String voidedAt;

        public Builder authorizedAt(String authorizedAt) {
            this.authorizedAt = authorizedAt;
            return this;
        }

        public Builder capturedAt(String capturedAt) {
            this.capturedAt = capturedAt;
            return this;
        }

        public Builder voidedAt(String voidedAt) {
            this.voidedAt = voidedAt;
            return this;
        }

        public CardPaymentTimeline build() {
            return new CardPaymentTimeline(this.authorizedAt, this.capturedAt, this.voidedAt);
        }
    }
}

