/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CashDrawerDevice {
    private final String id;
    private final String name;

    @JsonCreator
    public CashDrawerDevice(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name) {
        this.id = id;
        this.name = name;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CashDrawerDevice)) {
            return false;
        }
        CashDrawerDevice other = (CashDrawerDevice)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "CashDrawerDevice [id=" + this.id + ", name=" + this.name + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).name(this.getName());
        return builder;
    }

    public static class Builder {
        private String id;
        private String name;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public CashDrawerDevice build() {
            return new CashDrawerDevice(this.id, this.name);
        }
    }
}

