/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CashDrawerDevice;
import com.squareup.square.models.Money;
import java.util.List;
import java.util.Objects;

public class CashDrawerShift {
    private final String id;
    private final String state;
    private final String openedAt;
    private final String endedAt;
    private final String closedAt;
    private final List<String> employeeIds;
    private final String openingEmployeeId;
    private final String endingEmployeeId;
    private final String closingEmployeeId;
    private final String description;
    private final Money openedCashMoney;
    private final Money cashPaymentMoney;
    private final Money cashRefundsMoney;
    private final Money cashPaidInMoney;
    private final Money cashPaidOutMoney;
    private final Money expectedCashMoney;
    private final Money closedCashMoney;
    private final CashDrawerDevice device;

    @JsonCreator
    public CashDrawerShift(@JsonProperty(value="id") String id, @JsonProperty(value="state") String state, @JsonProperty(value="opened_at") String openedAt, @JsonProperty(value="ended_at") String endedAt, @JsonProperty(value="closed_at") String closedAt, @JsonProperty(value="employee_ids") List<String> employeeIds, @JsonProperty(value="opening_employee_id") String openingEmployeeId, @JsonProperty(value="ending_employee_id") String endingEmployeeId, @JsonProperty(value="closing_employee_id") String closingEmployeeId, @JsonProperty(value="description") String description, @JsonProperty(value="opened_cash_money") Money openedCashMoney, @JsonProperty(value="cash_payment_money") Money cashPaymentMoney, @JsonProperty(value="cash_refunds_money") Money cashRefundsMoney, @JsonProperty(value="cash_paid_in_money") Money cashPaidInMoney, @JsonProperty(value="cash_paid_out_money") Money cashPaidOutMoney, @JsonProperty(value="expected_cash_money") Money expectedCashMoney, @JsonProperty(value="closed_cash_money") Money closedCashMoney, @JsonProperty(value="device") CashDrawerDevice device) {
        this.id = id;
        this.state = state;
        this.openedAt = openedAt;
        this.endedAt = endedAt;
        this.closedAt = closedAt;
        this.employeeIds = employeeIds;
        this.openingEmployeeId = openingEmployeeId;
        this.endingEmployeeId = endingEmployeeId;
        this.closingEmployeeId = closingEmployeeId;
        this.description = description;
        this.openedCashMoney = openedCashMoney;
        this.cashPaymentMoney = cashPaymentMoney;
        this.cashRefundsMoney = cashRefundsMoney;
        this.cashPaidInMoney = cashPaidInMoney;
        this.cashPaidOutMoney = cashPaidOutMoney;
        this.expectedCashMoney = expectedCashMoney;
        this.closedCashMoney = closedCashMoney;
        this.device = device;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="opened_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOpenedAt() {
        return this.openedAt;
    }

    @JsonGetter(value="ended_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndedAt() {
        return this.endedAt;
    }

    @JsonGetter(value="closed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClosedAt() {
        return this.closedAt;
    }

    @JsonGetter(value="employee_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getEmployeeIds() {
        return this.employeeIds;
    }

    @JsonGetter(value="opening_employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOpeningEmployeeId() {
        return this.openingEmployeeId;
    }

    @JsonGetter(value="ending_employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndingEmployeeId() {
        return this.endingEmployeeId;
    }

    @JsonGetter(value="closing_employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClosingEmployeeId() {
        return this.closingEmployeeId;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="opened_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getOpenedCashMoney() {
        return this.openedCashMoney;
    }

    @JsonGetter(value="cash_payment_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getCashPaymentMoney() {
        return this.cashPaymentMoney;
    }

    @JsonGetter(value="cash_refunds_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getCashRefundsMoney() {
        return this.cashRefundsMoney;
    }

    @JsonGetter(value="cash_paid_in_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getCashPaidInMoney() {
        return this.cashPaidInMoney;
    }

    @JsonGetter(value="cash_paid_out_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getCashPaidOutMoney() {
        return this.cashPaidOutMoney;
    }

    @JsonGetter(value="expected_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getExpectedCashMoney() {
        return this.expectedCashMoney;
    }

    @JsonGetter(value="closed_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getClosedCashMoney() {
        return this.closedCashMoney;
    }

    @JsonGetter(value="device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CashDrawerDevice getDevice() {
        return this.device;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.employeeIds, this.openingEmployeeId, this.endingEmployeeId, this.closingEmployeeId, this.description, this.openedCashMoney, this.cashPaymentMoney, this.cashRefundsMoney, this.cashPaidInMoney, this.cashPaidOutMoney, this.expectedCashMoney, this.closedCashMoney, this.device);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CashDrawerShift)) {
            return false;
        }
        CashDrawerShift other = (CashDrawerShift)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.state, other.state) && Objects.equals(this.openedAt, other.openedAt) && Objects.equals(this.endedAt, other.endedAt) && Objects.equals(this.closedAt, other.closedAt) && Objects.equals(this.employeeIds, other.employeeIds) && Objects.equals(this.openingEmployeeId, other.openingEmployeeId) && Objects.equals(this.endingEmployeeId, other.endingEmployeeId) && Objects.equals(this.closingEmployeeId, other.closingEmployeeId) && Objects.equals(this.description, other.description) && Objects.equals(this.openedCashMoney, other.openedCashMoney) && Objects.equals(this.cashPaymentMoney, other.cashPaymentMoney) && Objects.equals(this.cashRefundsMoney, other.cashRefundsMoney) && Objects.equals(this.cashPaidInMoney, other.cashPaidInMoney) && Objects.equals(this.cashPaidOutMoney, other.cashPaidOutMoney) && Objects.equals(this.expectedCashMoney, other.expectedCashMoney) && Objects.equals(this.closedCashMoney, other.closedCashMoney) && Objects.equals(this.device, other.device);
    }

    public String toString() {
        return "CashDrawerShift [id=" + this.id + ", state=" + this.state + ", openedAt=" + this.openedAt + ", endedAt=" + this.endedAt + ", closedAt=" + this.closedAt + ", employeeIds=" + this.employeeIds + ", openingEmployeeId=" + this.openingEmployeeId + ", endingEmployeeId=" + this.endingEmployeeId + ", closingEmployeeId=" + this.closingEmployeeId + ", description=" + this.description + ", openedCashMoney=" + this.openedCashMoney + ", cashPaymentMoney=" + this.cashPaymentMoney + ", cashRefundsMoney=" + this.cashRefundsMoney + ", cashPaidInMoney=" + this.cashPaidInMoney + ", cashPaidOutMoney=" + this.cashPaidOutMoney + ", expectedCashMoney=" + this.expectedCashMoney + ", closedCashMoney=" + this.closedCashMoney + ", device=" + this.device + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).state(this.getState()).openedAt(this.getOpenedAt()).endedAt(this.getEndedAt()).closedAt(this.getClosedAt()).employeeIds(this.getEmployeeIds()).openingEmployeeId(this.getOpeningEmployeeId()).endingEmployeeId(this.getEndingEmployeeId()).closingEmployeeId(this.getClosingEmployeeId()).description(this.getDescription()).openedCashMoney(this.getOpenedCashMoney()).cashPaymentMoney(this.getCashPaymentMoney()).cashRefundsMoney(this.getCashRefundsMoney()).cashPaidInMoney(this.getCashPaidInMoney()).cashPaidOutMoney(this.getCashPaidOutMoney()).expectedCashMoney(this.getExpectedCashMoney()).closedCashMoney(this.getClosedCashMoney()).device(this.getDevice());
        return builder;
    }

    public static class Builder {
        private String id;
        private String state;
        private String openedAt;
        private String endedAt;
        private String closedAt;
        private List<String> employeeIds;
        private String openingEmployeeId;
        private String endingEmployeeId;
        private String closingEmployeeId;
        private String description;
        private Money openedCashMoney;
        private Money cashPaymentMoney;
        private Money cashRefundsMoney;
        private Money cashPaidInMoney;
        private Money cashPaidOutMoney;
        private Money expectedCashMoney;
        private Money closedCashMoney;
        private CashDrawerDevice device;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder openedAt(String openedAt) {
            this.openedAt = openedAt;
            return this;
        }

        public Builder endedAt(String endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public Builder closedAt(String closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        public Builder employeeIds(List<String> employeeIds) {
            this.employeeIds = employeeIds;
            return this;
        }

        public Builder openingEmployeeId(String openingEmployeeId) {
            this.openingEmployeeId = openingEmployeeId;
            return this;
        }

        public Builder endingEmployeeId(String endingEmployeeId) {
            this.endingEmployeeId = endingEmployeeId;
            return this;
        }

        public Builder closingEmployeeId(String closingEmployeeId) {
            this.closingEmployeeId = closingEmployeeId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder openedCashMoney(Money openedCashMoney) {
            this.openedCashMoney = openedCashMoney;
            return this;
        }

        public Builder cashPaymentMoney(Money cashPaymentMoney) {
            this.cashPaymentMoney = cashPaymentMoney;
            return this;
        }

        public Builder cashRefundsMoney(Money cashRefundsMoney) {
            this.cashRefundsMoney = cashRefundsMoney;
            return this;
        }

        public Builder cashPaidInMoney(Money cashPaidInMoney) {
            this.cashPaidInMoney = cashPaidInMoney;
            return this;
        }

        public Builder cashPaidOutMoney(Money cashPaidOutMoney) {
            this.cashPaidOutMoney = cashPaidOutMoney;
            return this;
        }

        public Builder expectedCashMoney(Money expectedCashMoney) {
            this.expectedCashMoney = expectedCashMoney;
            return this;
        }

        public Builder closedCashMoney(Money closedCashMoney) {
            this.closedCashMoney = closedCashMoney;
            return this;
        }

        public Builder device(CashDrawerDevice device) {
            this.device = device;
            return this;
        }

        public CashDrawerShift build() {
            return new CashDrawerShift(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.employeeIds, this.openingEmployeeId, this.endingEmployeeId, this.closingEmployeeId, this.description, this.openedCashMoney, this.cashPaymentMoney, this.cashRefundsMoney, this.cashPaidInMoney, this.cashPaidOutMoney, this.expectedCashMoney, this.closedCashMoney, this.device);
        }
    }
}

