/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class CashDrawerShiftEvent {
    private final String id;
    private final String employeeId;
    private final String eventType;
    private final Money eventMoney;
    private final String createdAt;
    private final String description;

    @JsonCreator
    public CashDrawerShiftEvent(@JsonProperty(value="id") String id, @JsonProperty(value="employee_id") String employeeId, @JsonProperty(value="event_type") String eventType, @JsonProperty(value="event_money") Money eventMoney, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="description") String description) {
        this.id = id;
        this.employeeId = employeeId;
        this.eventType = eventType;
        this.eventMoney = eventMoney;
        this.createdAt = createdAt;
        this.description = description;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmployeeId() {
        return this.employeeId;
    }

    @JsonGetter(value="event_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEventType() {
        return this.eventType;
    }

    @JsonGetter(value="event_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getEventMoney() {
        return this.eventMoney;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.employeeId, this.eventType, this.eventMoney, this.createdAt, this.description);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CashDrawerShiftEvent)) {
            return false;
        }
        CashDrawerShiftEvent other = (CashDrawerShiftEvent)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.employeeId, other.employeeId) && Objects.equals(this.eventType, other.eventType) && Objects.equals(this.eventMoney, other.eventMoney) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.description, other.description);
    }

    public String toString() {
        return "CashDrawerShiftEvent [id=" + this.id + ", employeeId=" + this.employeeId + ", eventType=" + this.eventType + ", eventMoney=" + this.eventMoney + ", createdAt=" + this.createdAt + ", description=" + this.description + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).employeeId(this.getEmployeeId()).eventType(this.getEventType()).eventMoney(this.getEventMoney()).createdAt(this.getCreatedAt()).description(this.getDescription());
        return builder;
    }

    public static class Builder {
        private String id;
        private String employeeId;
        private String eventType;
        private Money eventMoney;
        private String createdAt;
        private String description;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        public Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder eventMoney(Money eventMoney) {
            this.eventMoney = eventMoney;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public CashDrawerShiftEvent build() {
            return new CashDrawerShiftEvent(this.id, this.employeeId, this.eventType, this.eventMoney, this.createdAt, this.description);
        }
    }
}

