/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class CashDrawerShiftSummary {
    private final String id;
    private final String state;
    private final String openedAt;
    private final String endedAt;
    private final String closedAt;
    private final String description;
    private final Money openedCashMoney;
    private final Money expectedCashMoney;
    private final Money closedCashMoney;

    @JsonCreator
    public CashDrawerShiftSummary(@JsonProperty(value="id") String id, @JsonProperty(value="state") String state, @JsonProperty(value="opened_at") String openedAt, @JsonProperty(value="ended_at") String endedAt, @JsonProperty(value="closed_at") String closedAt, @JsonProperty(value="description") String description, @JsonProperty(value="opened_cash_money") Money openedCashMoney, @JsonProperty(value="expected_cash_money") Money expectedCashMoney, @JsonProperty(value="closed_cash_money") Money closedCashMoney) {
        this.id = id;
        this.state = state;
        this.openedAt = openedAt;
        this.endedAt = endedAt;
        this.closedAt = closedAt;
        this.description = description;
        this.openedCashMoney = openedCashMoney;
        this.expectedCashMoney = expectedCashMoney;
        this.closedCashMoney = closedCashMoney;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="opened_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOpenedAt() {
        return this.openedAt;
    }

    @JsonGetter(value="ended_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndedAt() {
        return this.endedAt;
    }

    @JsonGetter(value="closed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClosedAt() {
        return this.closedAt;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="opened_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getOpenedCashMoney() {
        return this.openedCashMoney;
    }

    @JsonGetter(value="expected_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getExpectedCashMoney() {
        return this.expectedCashMoney;
    }

    @JsonGetter(value="closed_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getClosedCashMoney() {
        return this.closedCashMoney;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.description, this.openedCashMoney, this.expectedCashMoney, this.closedCashMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CashDrawerShiftSummary)) {
            return false;
        }
        CashDrawerShiftSummary other = (CashDrawerShiftSummary)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.state, other.state) && Objects.equals(this.openedAt, other.openedAt) && Objects.equals(this.endedAt, other.endedAt) && Objects.equals(this.closedAt, other.closedAt) && Objects.equals(this.description, other.description) && Objects.equals(this.openedCashMoney, other.openedCashMoney) && Objects.equals(this.expectedCashMoney, other.expectedCashMoney) && Objects.equals(this.closedCashMoney, other.closedCashMoney);
    }

    public String toString() {
        return "CashDrawerShiftSummary [id=" + this.id + ", state=" + this.state + ", openedAt=" + this.openedAt + ", endedAt=" + this.endedAt + ", closedAt=" + this.closedAt + ", description=" + this.description + ", openedCashMoney=" + this.openedCashMoney + ", expectedCashMoney=" + this.expectedCashMoney + ", closedCashMoney=" + this.closedCashMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).state(this.getState()).openedAt(this.getOpenedAt()).endedAt(this.getEndedAt()).closedAt(this.getClosedAt()).description(this.getDescription()).openedCashMoney(this.getOpenedCashMoney()).expectedCashMoney(this.getExpectedCashMoney()).closedCashMoney(this.getClosedCashMoney());
        return builder;
    }

    public static class Builder {
        private String id;
        private String state;
        private String openedAt;
        private String endedAt;
        private String closedAt;
        private String description;
        private Money openedCashMoney;
        private Money expectedCashMoney;
        private Money closedCashMoney;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder openedAt(String openedAt) {
            this.openedAt = openedAt;
            return this;
        }

        public Builder endedAt(String endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public Builder closedAt(String closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder openedCashMoney(Money openedCashMoney) {
            this.openedCashMoney = openedCashMoney;
            return this;
        }

        public Builder expectedCashMoney(Money expectedCashMoney) {
            this.expectedCashMoney = expectedCashMoney;
            return this;
        }

        public Builder closedCashMoney(Money closedCashMoney) {
            this.closedCashMoney = closedCashMoney;
            return this;
        }

        public CashDrawerShiftSummary build() {
            return new CashDrawerShiftSummary(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.description, this.openedCashMoney, this.expectedCashMoney, this.closedCashMoney);
        }
    }
}

