/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class CashPaymentDetails {
    private final Money buyerSuppliedMoney;
    private final Money changeBackMoney;

    @JsonCreator
    public CashPaymentDetails(@JsonProperty(value="buyer_supplied_money") Money buyerSuppliedMoney, @JsonProperty(value="change_back_money") Money changeBackMoney) {
        this.buyerSuppliedMoney = buyerSuppliedMoney;
        this.changeBackMoney = changeBackMoney;
    }

    @JsonGetter(value="buyer_supplied_money")
    public Money getBuyerSuppliedMoney() {
        return this.buyerSuppliedMoney;
    }

    @JsonGetter(value="change_back_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getChangeBackMoney() {
        return this.changeBackMoney;
    }

    public int hashCode() {
        return Objects.hash(this.buyerSuppliedMoney, this.changeBackMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CashPaymentDetails)) {
            return false;
        }
        CashPaymentDetails other = (CashPaymentDetails)obj;
        return Objects.equals(this.buyerSuppliedMoney, other.buyerSuppliedMoney) && Objects.equals(this.changeBackMoney, other.changeBackMoney);
    }

    public String toString() {
        return "CashPaymentDetails [buyerSuppliedMoney=" + this.buyerSuppliedMoney + ", changeBackMoney=" + this.changeBackMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.buyerSuppliedMoney).changeBackMoney(this.getChangeBackMoney());
        return builder;
    }

    public static class Builder {
        private Money buyerSuppliedMoney;
        private Money changeBackMoney;

        public Builder(Money buyerSuppliedMoney) {
            this.buyerSuppliedMoney = buyerSuppliedMoney;
        }

        public Builder buyerSuppliedMoney(Money buyerSuppliedMoney) {
            this.buyerSuppliedMoney = buyerSuppliedMoney;
            return this;
        }

        public Builder changeBackMoney(Money changeBackMoney) {
            this.changeBackMoney = changeBackMoney;
            return this;
        }

        public CashPaymentDetails build() {
            return new CashPaymentDetails(this.buyerSuppliedMoney, this.changeBackMoney);
        }
    }
}

