/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class CatalogCategory {
    private final String name;
    private final List<String> imageIds;

    @JsonCreator
    public CatalogCategory(@JsonProperty(value="name") String name, @JsonProperty(value="image_ids") List<String> imageIds) {
        this.name = name;
        this.imageIds = imageIds;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="image_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getImageIds() {
        return this.imageIds;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.imageIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogCategory)) {
            return false;
        }
        CatalogCategory other = (CatalogCategory)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.imageIds, other.imageIds);
    }

    public String toString() {
        return "CatalogCategory [name=" + this.name + ", imageIds=" + this.imageIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).imageIds(this.getImageIds());
        return builder;
    }

    public static class Builder {
        private String name;
        private List<String> imageIds;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = imageIds;
            return this;
        }

        public CatalogCategory build() {
            return new CatalogCategory(this.name, this.imageIds);
        }
    }
}

