/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogCustomAttributeDefinitionNumberConfig;
import com.squareup.square.models.CatalogCustomAttributeDefinitionSelectionConfig;
import com.squareup.square.models.CatalogCustomAttributeDefinitionStringConfig;
import com.squareup.square.models.SourceApplication;
import java.util.List;
import java.util.Objects;

public class CatalogCustomAttributeDefinition {
    private final String type;
    private final String name;
    private final String description;
    private final SourceApplication sourceApplication;
    private final List<String> allowedObjectTypes;
    private final String sellerVisibility;
    private final String appVisibility;
    private final CatalogCustomAttributeDefinitionStringConfig stringConfig;
    private final CatalogCustomAttributeDefinitionNumberConfig numberConfig;
    private final CatalogCustomAttributeDefinitionSelectionConfig selectionConfig;
    private final Integer customAttributeUsageCount;
    private final String key;

    @JsonCreator
    public CatalogCustomAttributeDefinition(@JsonProperty(value="type") String type, @JsonProperty(value="name") String name, @JsonProperty(value="allowed_object_types") List<String> allowedObjectTypes, @JsonProperty(value="description") String description, @JsonProperty(value="source_application") SourceApplication sourceApplication, @JsonProperty(value="seller_visibility") String sellerVisibility, @JsonProperty(value="app_visibility") String appVisibility, @JsonProperty(value="string_config") CatalogCustomAttributeDefinitionStringConfig stringConfig, @JsonProperty(value="number_config") CatalogCustomAttributeDefinitionNumberConfig numberConfig, @JsonProperty(value="selection_config") CatalogCustomAttributeDefinitionSelectionConfig selectionConfig, @JsonProperty(value="custom_attribute_usage_count") Integer customAttributeUsageCount, @JsonProperty(value="key") String key) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.sourceApplication = sourceApplication;
        this.allowedObjectTypes = allowedObjectTypes;
        this.sellerVisibility = sellerVisibility;
        this.appVisibility = appVisibility;
        this.stringConfig = stringConfig;
        this.numberConfig = numberConfig;
        this.selectionConfig = selectionConfig;
        this.customAttributeUsageCount = customAttributeUsageCount;
        this.key = key;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="source_application")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SourceApplication getSourceApplication() {
        return this.sourceApplication;
    }

    @JsonGetter(value="allowed_object_types")
    public List<String> getAllowedObjectTypes() {
        return this.allowedObjectTypes;
    }

    @JsonGetter(value="seller_visibility")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSellerVisibility() {
        return this.sellerVisibility;
    }

    @JsonGetter(value="app_visibility")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAppVisibility() {
        return this.appVisibility;
    }

    @JsonGetter(value="string_config")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogCustomAttributeDefinitionStringConfig getStringConfig() {
        return this.stringConfig;
    }

    @JsonGetter(value="number_config")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogCustomAttributeDefinitionNumberConfig getNumberConfig() {
        return this.numberConfig;
    }

    @JsonGetter(value="selection_config")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogCustomAttributeDefinitionSelectionConfig getSelectionConfig() {
        return this.selectionConfig;
    }

    @JsonGetter(value="custom_attribute_usage_count")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getCustomAttributeUsageCount() {
        return this.customAttributeUsageCount;
    }

    @JsonGetter(value="key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.description, this.sourceApplication, this.allowedObjectTypes, this.sellerVisibility, this.appVisibility, this.stringConfig, this.numberConfig, this.selectionConfig, this.customAttributeUsageCount, this.key);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogCustomAttributeDefinition)) {
            return false;
        }
        CatalogCustomAttributeDefinition other = (CatalogCustomAttributeDefinition)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.sourceApplication, other.sourceApplication) && Objects.equals(this.allowedObjectTypes, other.allowedObjectTypes) && Objects.equals(this.sellerVisibility, other.sellerVisibility) && Objects.equals(this.appVisibility, other.appVisibility) && Objects.equals(this.stringConfig, other.stringConfig) && Objects.equals(this.numberConfig, other.numberConfig) && Objects.equals(this.selectionConfig, other.selectionConfig) && Objects.equals(this.customAttributeUsageCount, other.customAttributeUsageCount) && Objects.equals(this.key, other.key);
    }

    public String toString() {
        return "CatalogCustomAttributeDefinition [type=" + this.type + ", name=" + this.name + ", allowedObjectTypes=" + this.allowedObjectTypes + ", description=" + this.description + ", sourceApplication=" + this.sourceApplication + ", sellerVisibility=" + this.sellerVisibility + ", appVisibility=" + this.appVisibility + ", stringConfig=" + this.stringConfig + ", numberConfig=" + this.numberConfig + ", selectionConfig=" + this.selectionConfig + ", customAttributeUsageCount=" + this.customAttributeUsageCount + ", key=" + this.key + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type, this.name, this.allowedObjectTypes).description(this.getDescription()).sourceApplication(this.getSourceApplication()).sellerVisibility(this.getSellerVisibility()).appVisibility(this.getAppVisibility()).stringConfig(this.getStringConfig()).numberConfig(this.getNumberConfig()).selectionConfig(this.getSelectionConfig()).customAttributeUsageCount(this.getCustomAttributeUsageCount()).key(this.getKey());
        return builder;
    }

    public static class Builder {
        private String type;
        private String name;
        private List<String> allowedObjectTypes;
        private String description;
        private SourceApplication sourceApplication;
        private String sellerVisibility;
        private String appVisibility;
        private CatalogCustomAttributeDefinitionStringConfig stringConfig;
        private CatalogCustomAttributeDefinitionNumberConfig numberConfig;
        private CatalogCustomAttributeDefinitionSelectionConfig selectionConfig;
        private Integer customAttributeUsageCount;
        private String key;

        public Builder(String type, String name, List<String> allowedObjectTypes) {
            this.type = type;
            this.name = name;
            this.allowedObjectTypes = allowedObjectTypes;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder allowedObjectTypes(List<String> allowedObjectTypes) {
            this.allowedObjectTypes = allowedObjectTypes;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder sourceApplication(SourceApplication sourceApplication) {
            this.sourceApplication = sourceApplication;
            return this;
        }

        public Builder sellerVisibility(String sellerVisibility) {
            this.sellerVisibility = sellerVisibility;
            return this;
        }

        public Builder appVisibility(String appVisibility) {
            this.appVisibility = appVisibility;
            return this;
        }

        public Builder stringConfig(CatalogCustomAttributeDefinitionStringConfig stringConfig) {
            this.stringConfig = stringConfig;
            return this;
        }

        public Builder numberConfig(CatalogCustomAttributeDefinitionNumberConfig numberConfig) {
            this.numberConfig = numberConfig;
            return this;
        }

        public Builder selectionConfig(CatalogCustomAttributeDefinitionSelectionConfig selectionConfig) {
            this.selectionConfig = selectionConfig;
            return this;
        }

        public Builder customAttributeUsageCount(Integer customAttributeUsageCount) {
            this.customAttributeUsageCount = customAttributeUsageCount;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public CatalogCustomAttributeDefinition build() {
            return new CatalogCustomAttributeDefinition(this.type, this.name, this.allowedObjectTypes, this.description, this.sourceApplication, this.sellerVisibility, this.appVisibility, this.stringConfig, this.numberConfig, this.selectionConfig, this.customAttributeUsageCount, this.key);
        }
    }
}

