/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection;
import java.util.List;
import java.util.Objects;

public class CatalogCustomAttributeDefinitionSelectionConfig {
    private final Integer maxAllowedSelections;
    private final List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection> allowedSelections;

    @JsonCreator
    public CatalogCustomAttributeDefinitionSelectionConfig(@JsonProperty(value="max_allowed_selections") Integer maxAllowedSelections, @JsonProperty(value="allowed_selections") List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection> allowedSelections) {
        this.maxAllowedSelections = maxAllowedSelections;
        this.allowedSelections = allowedSelections;
    }

    @JsonGetter(value="max_allowed_selections")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxAllowedSelections() {
        return this.maxAllowedSelections;
    }

    @JsonGetter(value="allowed_selections")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection> getAllowedSelections() {
        return this.allowedSelections;
    }

    public int hashCode() {
        return Objects.hash(this.maxAllowedSelections, this.allowedSelections);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogCustomAttributeDefinitionSelectionConfig)) {
            return false;
        }
        CatalogCustomAttributeDefinitionSelectionConfig other = (CatalogCustomAttributeDefinitionSelectionConfig)obj;
        return Objects.equals(this.maxAllowedSelections, other.maxAllowedSelections) && Objects.equals(this.allowedSelections, other.allowedSelections);
    }

    public String toString() {
        return "CatalogCustomAttributeDefinitionSelectionConfig [maxAllowedSelections=" + this.maxAllowedSelections + ", allowedSelections=" + this.allowedSelections + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().maxAllowedSelections(this.getMaxAllowedSelections()).allowedSelections(this.getAllowedSelections());
        return builder;
    }

    public static class Builder {
        private Integer maxAllowedSelections;
        private List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection> allowedSelections;

        public Builder maxAllowedSelections(Integer maxAllowedSelections) {
            this.maxAllowedSelections = maxAllowedSelections;
            return this;
        }

        public Builder allowedSelections(List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection> allowedSelections) {
            this.allowedSelections = allowedSelections;
            return this;
        }

        public CatalogCustomAttributeDefinitionSelectionConfig build() {
            return new CatalogCustomAttributeDefinitionSelectionConfig(this.maxAllowedSelections, this.allowedSelections);
        }
    }
}

