/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class CatalogCustomAttributeValue {
    private final String name;
    private final String stringValue;
    private final String customAttributeDefinitionId;
    private final String type;
    private final String numberValue;
    private final Boolean booleanValue;
    private final List<String> selectionUidValues;
    private final String key;

    @JsonCreator
    public CatalogCustomAttributeValue(@JsonProperty(value="name") String name, @JsonProperty(value="string_value") String stringValue, @JsonProperty(value="custom_attribute_definition_id") String customAttributeDefinitionId, @JsonProperty(value="type") String type, @JsonProperty(value="number_value") String numberValue, @JsonProperty(value="boolean_value") Boolean booleanValue, @JsonProperty(value="selection_uid_values") List<String> selectionUidValues, @JsonProperty(value="key") String key) {
        this.name = name;
        this.stringValue = stringValue;
        this.customAttributeDefinitionId = customAttributeDefinitionId;
        this.type = type;
        this.numberValue = numberValue;
        this.booleanValue = booleanValue;
        this.selectionUidValues = selectionUidValues;
        this.key = key;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="string_value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStringValue() {
        return this.stringValue;
    }

    @JsonGetter(value="custom_attribute_definition_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomAttributeDefinitionId() {
        return this.customAttributeDefinitionId;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="number_value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNumberValue() {
        return this.numberValue;
    }

    @JsonGetter(value="boolean_value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    @JsonGetter(value="selection_uid_values")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getSelectionUidValues() {
        return this.selectionUidValues;
    }

    @JsonGetter(value="key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.stringValue, this.customAttributeDefinitionId, this.type, this.numberValue, this.booleanValue, this.selectionUidValues, this.key);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogCustomAttributeValue)) {
            return false;
        }
        CatalogCustomAttributeValue other = (CatalogCustomAttributeValue)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.stringValue, other.stringValue) && Objects.equals(this.customAttributeDefinitionId, other.customAttributeDefinitionId) && Objects.equals(this.type, other.type) && Objects.equals(this.numberValue, other.numberValue) && Objects.equals(this.booleanValue, other.booleanValue) && Objects.equals(this.selectionUidValues, other.selectionUidValues) && Objects.equals(this.key, other.key);
    }

    public String toString() {
        return "CatalogCustomAttributeValue [name=" + this.name + ", stringValue=" + this.stringValue + ", customAttributeDefinitionId=" + this.customAttributeDefinitionId + ", type=" + this.type + ", numberValue=" + this.numberValue + ", booleanValue=" + this.booleanValue + ", selectionUidValues=" + this.selectionUidValues + ", key=" + this.key + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).stringValue(this.getStringValue()).customAttributeDefinitionId(this.getCustomAttributeDefinitionId()).type(this.getType()).numberValue(this.getNumberValue()).booleanValue(this.getBooleanValue()).selectionUidValues(this.getSelectionUidValues()).key(this.getKey());
        return builder;
    }

    public static class Builder {
        private String name;
        private String stringValue;
        private String customAttributeDefinitionId;
        private String type;
        private String numberValue;
        private Boolean booleanValue;
        private List<String> selectionUidValues;
        private String key;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public Builder customAttributeDefinitionId(String customAttributeDefinitionId) {
            this.customAttributeDefinitionId = customAttributeDefinitionId;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder numberValue(String numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        public Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public Builder selectionUidValues(List<String> selectionUidValues) {
            this.selectionUidValues = selectionUidValues;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public CatalogCustomAttributeValue build() {
            return new CatalogCustomAttributeValue(this.name, this.stringValue, this.customAttributeDefinitionId, this.type, this.numberValue, this.booleanValue, this.selectionUidValues, this.key);
        }
    }
}

