/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class CatalogDiscount {
    private final String name;
    private final String discountType;
    private final String percentage;
    private final Money amountMoney;
    private final Boolean pinRequired;
    private final String labelColor;
    private final String modifyTaxBasis;
    private final Money maximumAmountMoney;

    @JsonCreator
    public CatalogDiscount(@JsonProperty(value="name") String name, @JsonProperty(value="discount_type") String discountType, @JsonProperty(value="percentage") String percentage, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="pin_required") Boolean pinRequired, @JsonProperty(value="label_color") String labelColor, @JsonProperty(value="modify_tax_basis") String modifyTaxBasis, @JsonProperty(value="maximum_amount_money") Money maximumAmountMoney) {
        this.name = name;
        this.discountType = discountType;
        this.percentage = percentage;
        this.amountMoney = amountMoney;
        this.pinRequired = pinRequired;
        this.labelColor = labelColor;
        this.modifyTaxBasis = modifyTaxBasis;
        this.maximumAmountMoney = maximumAmountMoney;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="discount_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDiscountType() {
        return this.discountType;
    }

    @JsonGetter(value="percentage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPercentage() {
        return this.percentage;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="pin_required")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getPinRequired() {
        return this.pinRequired;
    }

    @JsonGetter(value="label_color")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLabelColor() {
        return this.labelColor;
    }

    @JsonGetter(value="modify_tax_basis")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getModifyTaxBasis() {
        return this.modifyTaxBasis;
    }

    @JsonGetter(value="maximum_amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getMaximumAmountMoney() {
        return this.maximumAmountMoney;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.discountType, this.percentage, this.amountMoney, this.pinRequired, this.labelColor, this.modifyTaxBasis, this.maximumAmountMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogDiscount)) {
            return false;
        }
        CatalogDiscount other = (CatalogDiscount)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.discountType, other.discountType) && Objects.equals(this.percentage, other.percentage) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.pinRequired, other.pinRequired) && Objects.equals(this.labelColor, other.labelColor) && Objects.equals(this.modifyTaxBasis, other.modifyTaxBasis) && Objects.equals(this.maximumAmountMoney, other.maximumAmountMoney);
    }

    public String toString() {
        return "CatalogDiscount [name=" + this.name + ", discountType=" + this.discountType + ", percentage=" + this.percentage + ", amountMoney=" + this.amountMoney + ", pinRequired=" + this.pinRequired + ", labelColor=" + this.labelColor + ", modifyTaxBasis=" + this.modifyTaxBasis + ", maximumAmountMoney=" + this.maximumAmountMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).discountType(this.getDiscountType()).percentage(this.getPercentage()).amountMoney(this.getAmountMoney()).pinRequired(this.getPinRequired()).labelColor(this.getLabelColor()).modifyTaxBasis(this.getModifyTaxBasis()).maximumAmountMoney(this.getMaximumAmountMoney());
        return builder;
    }

    public static class Builder {
        private String name;
        private String discountType;
        private String percentage;
        private Money amountMoney;
        private Boolean pinRequired;
        private String labelColor;
        private String modifyTaxBasis;
        private Money maximumAmountMoney;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder discountType(String discountType) {
            this.discountType = discountType;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder pinRequired(Boolean pinRequired) {
            this.pinRequired = pinRequired;
            return this;
        }

        public Builder labelColor(String labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public Builder modifyTaxBasis(String modifyTaxBasis) {
            this.modifyTaxBasis = modifyTaxBasis;
            return this;
        }

        public Builder maximumAmountMoney(Money maximumAmountMoney) {
            this.maximumAmountMoney = maximumAmountMoney;
            return this;
        }

        public CatalogDiscount build() {
            return new CatalogDiscount(this.name, this.discountType, this.percentage, this.amountMoney, this.pinRequired, this.labelColor, this.modifyTaxBasis, this.maximumAmountMoney);
        }
    }
}

