/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CatalogIdMapping {
    private final String clientObjectId;
    private final String objectId;

    @JsonCreator
    public CatalogIdMapping(@JsonProperty(value="client_object_id") String clientObjectId, @JsonProperty(value="object_id") String objectId) {
        this.clientObjectId = clientObjectId;
        this.objectId = objectId;
    }

    @JsonGetter(value="client_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientObjectId() {
        return this.clientObjectId;
    }

    @JsonGetter(value="object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getObjectId() {
        return this.objectId;
    }

    public int hashCode() {
        return Objects.hash(this.clientObjectId, this.objectId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogIdMapping)) {
            return false;
        }
        CatalogIdMapping other = (CatalogIdMapping)obj;
        return Objects.equals(this.clientObjectId, other.clientObjectId) && Objects.equals(this.objectId, other.objectId);
    }

    public String toString() {
        return "CatalogIdMapping [clientObjectId=" + this.clientObjectId + ", objectId=" + this.objectId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().clientObjectId(this.getClientObjectId()).objectId(this.getObjectId());
        return builder;
    }

    public static class Builder {
        private String clientObjectId;
        private String objectId;

        public Builder clientObjectId(String clientObjectId) {
            this.clientObjectId = clientObjectId;
            return this;
        }

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public CatalogIdMapping build() {
            return new CatalogIdMapping(this.clientObjectId, this.objectId);
        }
    }
}

