/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CatalogImage {
    private final String name;
    private final String url;
    private final String caption;
    private final String photoStudioOrderId;

    @JsonCreator
    public CatalogImage(@JsonProperty(value="name") String name, @JsonProperty(value="url") String url, @JsonProperty(value="caption") String caption, @JsonProperty(value="photo_studio_order_id") String photoStudioOrderId) {
        this.name = name;
        this.url = url;
        this.caption = caption;
        this.photoStudioOrderId = photoStudioOrderId;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUrl() {
        return this.url;
    }

    @JsonGetter(value="caption")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCaption() {
        return this.caption;
    }

    @JsonGetter(value="photo_studio_order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPhotoStudioOrderId() {
        return this.photoStudioOrderId;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.caption, this.photoStudioOrderId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogImage)) {
            return false;
        }
        CatalogImage other = (CatalogImage)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.url, other.url) && Objects.equals(this.caption, other.caption) && Objects.equals(this.photoStudioOrderId, other.photoStudioOrderId);
    }

    public String toString() {
        return "CatalogImage [name=" + this.name + ", url=" + this.url + ", caption=" + this.caption + ", photoStudioOrderId=" + this.photoStudioOrderId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).url(this.getUrl()).caption(this.getCaption()).photoStudioOrderId(this.getPhotoStudioOrderId());
        return builder;
    }

    public static class Builder {
        private String name;
        private String url;
        private String caption;
        private String photoStudioOrderId;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder photoStudioOrderId(String photoStudioOrderId) {
            this.photoStudioOrderId = photoStudioOrderId;
            return this;
        }

        public CatalogImage build() {
            return new CatalogImage(this.name, this.url, this.caption, this.photoStudioOrderId);
        }
    }
}

